/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxScraper {
    private static final Logger logger = Logger.getLogger(JmxScraper.class.getName());
    private MBeanReceiver receiver;
    private String hostPort;

    public JmxScraper(String hostPort, MBeanReceiver receiver) {
        this.hostPort = hostPort;
        this.receiver = receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScrape() throws Exception {
        MBeanServerConnection beanConn;
        JMXConnector jmxc = null;
        if (this.hostPort.isEmpty()) {
            beanConn = ManagementFactory.getPlatformMBeanServer();
        } else {
            String url = "service:jmx:rmi:///jndi/rmi://" + this.hostPort + "/jmxrmi";
            jmxc = JMXConnectorFactory.connect(new JMXServiceURL(url), null);
            beanConn = jmxc.getMBeanServerConnection();
        }
        try {
            TreeSet<ObjectName> mBeanNames = new TreeSet<ObjectName>(beanConn.queryNames(null, null));
            for (ObjectName name : mBeanNames) {
                this.scrapeBean(beanConn, name);
            }
        }
        finally {
            if (jmxc != null) {
                jmxc.close();
            }
        }
    }

    private void scrapeBean(MBeanServerConnection beanConn, ObjectName mbeanName) {
        MBeanInfo info;
        try {
            info = beanConn.getMBeanInfo(mbeanName);
        }
        catch (IOException e) {
            JmxScraper.logScrape(mbeanName.toString(), "getMBeanInfo Fail: " + e);
            return;
        }
        catch (JMException e) {
            JmxScraper.logScrape(mbeanName.toString(), "getMBeanInfo Fail: " + e);
            return;
        }
        MBeanAttributeInfo[] attrInfos = info.getAttributes();
        for (int idx = 0; idx < attrInfos.length; ++idx) {
            Object value;
            MBeanAttributeInfo attr = attrInfos[idx];
            if (!attr.isReadable()) {
                JmxScraper.logScrape(mbeanName, attr, "not readable");
                continue;
            }
            try {
                value = beanConn.getAttribute(mbeanName, attr.getName());
            }
            catch (Exception e) {
                JmxScraper.logScrape(mbeanName, attr, "Fail: " + e);
                continue;
            }
            JmxScraper.logScrape(mbeanName, attr, "process");
            this.processBeanValue(mbeanName.getDomain(), this.getKeyPropertyList(mbeanName), new LinkedList<String>(), attr.getName(), attr.getType(), attr.getDescription(), value);
        }
    }

    private LinkedHashMap<String, String> getKeyPropertyList(ObjectName mbeanName) {
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        String beanName = mbeanName.toString();
        int idx = beanName.indexOf(58) + 1;
        if (idx > 0) {
            String[] tokens = beanName.substring(idx).split(",|=");
            int i = 0;
            while (i < tokens.length - 1) {
                output.put(tokens[i++], tokens[i++]);
            }
        }
        return output;
    }

    private void processBeanValue(String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object value) {
        if (value == null) {
            JmxScraper.logScrape(domain + beanProperties + attrName, "null");
        } else if (value instanceof Number || value instanceof String) {
            JmxScraper.logScrape(domain + beanProperties + attrName, value.toString());
            this.receiver.recordBean(domain, beanProperties, attrKeys, attrName, attrType, attrDescription, value);
        } else if (value instanceof CompositeData) {
            JmxScraper.logScrape(domain + beanProperties + attrName, "compositedata");
            CompositeData composite = (CompositeData)value;
            CompositeType type = composite.getCompositeType();
            attrKeys = new LinkedList<String>(attrKeys);
            attrKeys.add(attrName);
            for (String key : type.keySet()) {
                String typ = type.getType(key).getTypeName();
                Object valu = composite.get(key);
                this.processBeanValue(domain, beanProperties, attrKeys, key, typ, type.getDescription(), valu);
            }
        } else if (value instanceof TabularData) {
            JmxScraper.logScrape(domain + beanProperties + attrName, "tabulardata");
            TabularData tds = (TabularData)value;
            TabularType tt = tds.getTabularType();
            List<String> rowKeys = tt.getIndexNames();
            LinkedHashMap<String, String> l2s = new LinkedHashMap<String, String>(beanProperties);
            CompositeType type = tt.getRowType();
            TreeSet<String> valueKeys = new TreeSet<String>(type.keySet());
            valueKeys.removeAll(rowKeys);
            LinkedList<String> extendedAttrKeys = new LinkedList<String>(attrKeys);
            extendedAttrKeys.add(attrName);
            for (Object valu : tds.values()) {
                if (valu instanceof CompositeData) {
                    CompositeData composite = (CompositeData)valu;
                    for (String idx : rowKeys) {
                        l2s.put(idx, composite.get(idx).toString());
                    }
                    for (String valueIdx : valueKeys) {
                        LinkedList<String> attrNames = extendedAttrKeys;
                        String typ = type.getType(valueIdx).getTypeName();
                        String name = valueIdx;
                        if (valueIdx.toLowerCase().equals("value")) {
                            attrNames = attrKeys;
                            name = attrName;
                        }
                        this.processBeanValue(domain, l2s, attrNames, name, typ, type.getDescription(), composite.get(valueIdx));
                    }
                    continue;
                }
                JmxScraper.logScrape(domain, "not a correct tabulardata format");
            }
        } else if (value.getClass().isArray()) {
            JmxScraper.logScrape(domain, "arrays are unsupported");
        } else {
            JmxScraper.logScrape(domain + beanProperties, attrType + " is not exported");
        }
    }

    private static void logScrape(ObjectName mbeanName, MBeanAttributeInfo attr, String msg) {
        JmxScraper.logScrape(mbeanName + "'_'" + attr.getName(), msg);
    }

    private static void logScrape(String name, String msg) {
        logger.log(Level.FINE, "scrape: '" + name + "': " + msg);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            new JmxScraper(args[0], new StdoutWriter()).doScrape();
        } else {
            new JmxScraper("", new StdoutWriter()).doScrape();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StdoutWriter
    implements MBeanReceiver {
        private StdoutWriter() {
        }

        @Override
        public void recordBean(String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object value) {
            System.out.println(domain + beanProperties + attrKeys + attrName + ": " + value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MBeanReceiver {
        public void recordBean(String var1, LinkedHashMap<String, String> var2, LinkedList<String> var3, String var4, String var5, String var6, Object var7);
    }
}

