/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.common.http.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.HashSet;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextFactory {
    private static final String[] PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"};

    private SSLContextFactory() {
    }

    public static SSLContext createSSLContext(String keyStoreFilename, String keyStorePassword, String certificateAlias) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream inputStream = new FileInputStream(keyStoreFilename);){
            keyStore.load(inputStream, keyStorePassword.toCharArray());
            HashSet<Object> certificateAliasesToRemove = new HashSet<Object>();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String keyStoreCertificateAlias = aliases.nextElement();
                if (keyStoreCertificateAlias.equals(certificateAlias)) continue;
                certificateAliasesToRemove.add(keyStoreCertificateAlias);
            }
            for (String string : certificateAliasesToRemove) {
                keyStore.deleteEntry(string);
            }
            if (!keyStore.containsAlias(certificateAlias)) {
                throw new GeneralSecurityException(String.format("certificate alias [%s] not found in keystore [%s]", certificateAlias, keyStoreFilename));
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext sslContext = SSLContextFactory.createSSLContext();
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            SSLContext sSLContext = sslContext;
            return sSLContext;
        }
    }

    private static SSLContext createSSLContext() throws GeneralSecurityException {
        for (int i = 0; i < PROTOCOLS.length; ++i) {
            try {
                return SSLContext.getInstance(PROTOCOLS[i]);
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        throw new GeneralSecurityException(String.format("No supported TLS protocols found", new Object[0]));
    }
}

