/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.common.http.authenticator;

import com.sun.net.httpserver.BasicAuthenticator;
import io.prometheus.jmx.common.http.authenticator.CacheKey;
import io.prometheus.jmx.common.http.authenticator.HexString;
import io.prometheus.jmx.common.util.Precondition;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2Authenticator
extends BasicAuthenticator {
    private static final int MAXIMUM_INVALID_CACHE_KEY_ENTRIES = 16;
    private final String username;
    private final String passwordHash;
    private final String algorithm;
    private final String salt;
    private final int iterations;
    private final int keyLength;
    private final Set<CacheKey> cacheKeys;
    private final LinkedList<CacheKey> invalidCacheKeys;

    public PBKDF2Authenticator(String realm, String username, String passwordHash, String algorithm, String salt, int iterations, int keyLength) throws GeneralSecurityException {
        super(realm);
        Precondition.notNullOrEmpty(username);
        Precondition.notNullOrEmpty(passwordHash);
        Precondition.notNullOrEmpty(algorithm);
        Precondition.notNullOrEmpty(salt);
        Precondition.IsGreaterThanOrEqualTo(1, iterations);
        Precondition.IsGreaterThanOrEqualTo(1, keyLength);
        SecretKeyFactory.getInstance(algorithm);
        this.username = username;
        this.passwordHash = passwordHash.toLowerCase().replace(":", "");
        this.algorithm = algorithm;
        this.salt = salt;
        this.iterations = iterations;
        this.keyLength = keyLength;
        this.cacheKeys = Collections.synchronizedSet(new HashSet());
        this.invalidCacheKeys = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCredentials(String username, String password) {
        boolean isValid;
        if (username == null || password == null) {
            return false;
        }
        CacheKey cacheKey = new CacheKey(username, password);
        if (this.cacheKeys.contains(cacheKey)) {
            return true;
        }
        LinkedList<CacheKey> linkedList = this.invalidCacheKeys;
        synchronized (linkedList) {
            if (this.invalidCacheKeys.contains(cacheKey)) {
                return false;
            }
        }
        boolean bl = isValid = this.username.equals(username) && this.passwordHash.equals(PBKDF2Authenticator.generatePasswordHash(this.algorithm, this.salt, this.iterations, this.keyLength, password));
        if (isValid) {
            this.cacheKeys.add(cacheKey);
        } else {
            LinkedList<CacheKey> linkedList2 = this.invalidCacheKeys;
            synchronized (linkedList2) {
                this.invalidCacheKeys.add(cacheKey);
                if (this.invalidCacheKeys.size() > 16) {
                    this.invalidCacheKeys.removeFirst();
                }
            }
        }
        return isValid;
    }

    private static String generatePasswordHash(String algorithm, String salt, int iterations, int keyLength, String password) {
        try {
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray(), salt.getBytes(StandardCharsets.UTF_8), iterations, keyLength * 8);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithm);
            byte[] secretKeyBytes = secretKeyFactory.generateSecret(pbeKeySpec).getEncoded();
            return HexString.toHex(secretKeyBytes);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

