/*
 * Decompiled with CFR 0.152.
 */
package reactor.tools.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.ClassWriter;
import reactor.tools.agent.ReactorDebugClassVisitor;

public class ReactorDebugAgent {
    private static final String INSTALLED_PROPERTY = "reactor.tools.agent.installed";
    private static Instrumentation instrumentation;

    @Deprecated
    public static void premain(String args, Instrumentation instrumentation) {
        ReactorDebugAgent.instrument(instrumentation);
        System.setProperty(INSTALLED_PROPERTY, "true");
    }

    public static synchronized void init() {
        if (System.getProperty(INSTALLED_PROPERTY) != null) {
            return;
        }
        if (instrumentation != null) {
            return;
        }
        instrumentation = ByteBuddyAgent.install();
        ReactorDebugAgent.instrument(instrumentation);
    }

    private static void instrument(Instrumentation instrumentation) {
        ClassFileTransformer transformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> clazz, ProtectionDomain protectionDomain, byte[] bytes) {
                if (loader == null) {
                    return null;
                }
                if (className == null || className.startsWith("java/") || className.startsWith("jdk/") || className.startsWith("sun/") || className.startsWith("com/sun/") || className.startsWith("reactor/core/")) {
                    return null;
                }
                if (clazz != null && (clazz.isPrimitive() || clazz.isArray() || clazz.isAnnotation() || clazz.isSynthetic())) {
                    return null;
                }
                ClassReader cr = new ClassReader(bytes);
                ClassWriter cw = new ClassWriter(cr, 1);
                AtomicBoolean changed = new AtomicBoolean();
                ReactorDebugClassVisitor classVisitor = new ReactorDebugClassVisitor((ClassVisitor)cw, changed);
                try {
                    cr.accept((ClassVisitor)classVisitor, 0);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw e;
                }
                if (!changed.get()) {
                    return null;
                }
                return cw.toByteArray();
            }
        };
        instrumentation.addTransformer(transformer, true);
    }

    public static synchronized void processExistingClasses() {
        if (System.getProperty(INSTALLED_PROPERTY) != null) {
            return;
        }
        if (instrumentation == null) {
            throw new IllegalStateException("Must be initialized first!");
        }
        try {
            Class[] classes = (Class[])Stream.of(instrumentation.getInitiatedClasses(ClassLoader.getSystemClassLoader())).filter(aClass -> {
                try {
                    if (aClass.getClassLoader() == null) {
                        return false;
                    }
                    if (aClass.isPrimitive() || aClass.isArray() || aClass.isInterface()) {
                        return false;
                    }
                    if (aClass.isAnnotation() || aClass.isSynthetic()) {
                        return false;
                    }
                    String name = aClass.getName();
                    if (name == null) {
                        return false;
                    }
                    if (name.startsWith("[")) {
                        return false;
                    }
                    if (name.startsWith("java.")) {
                        return false;
                    }
                    if (name.startsWith("sun.")) {
                        return false;
                    }
                    if (name.startsWith("com.sun.")) {
                        return false;
                    }
                    if (name.startsWith("jdk.")) {
                        return false;
                    }
                    if (name.startsWith("reactor.core.")) {
                        return false;
                    }
                    aClass.getConstructors();
                }
                catch (LinkageError e) {
                    return false;
                }
                return true;
            }).toArray(Class[]::new);
            instrumentation.retransformClasses(classes);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

