/*
 * Decompiled with CFR 0.152.
 */
package reactor.tools.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import reactor.tools.agent.CallSiteInfoAddingMethodVisitor;
import reactor.tools.agent.ReturnHandlingMethodVisitor;

public class ReactorDebugAgent {
    private static Instrumentation instrumentation;

    public static synchronized void init() {
        if (instrumentation != null) {
            return;
        }
        instrumentation = ByteBuddyAgent.install();
        ClassFileTransformer transformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> clazz, ProtectionDomain protectionDomain, byte[] bytes) {
                if (loader == null) {
                    return null;
                }
                if (className == null || className.startsWith("java/") || className.startsWith("jdk/") || className.startsWith("sun/") || className.startsWith("com/sun/") || className.startsWith("reactor/core/")) {
                    return null;
                }
                if (clazz != null && (clazz.isPrimitive() || clazz.isArray() || clazz.isAnnotation() || clazz.isSynthetic())) {
                    return null;
                }
                ClassReader cr = new ClassReader(bytes);
                ClassWriter cw = new ClassWriter(cr, 1);
                final AtomicBoolean changed = new AtomicBoolean();
                ClassVisitor classVisitor = new ClassVisitor(458752, (ClassVisitor)cw){
                    private String currentClassName;
                    private String currentSource;
                    {
                        super(x0, x1);
                        this.currentClassName = "";
                        this.currentSource = "";
                    }

                    public void visitSource(String source, String debug) {
                        super.visitSource(source, debug);
                        this.currentSource = source;
                    }

                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        super.visit(version, access, name, signature, superName, interfaces);
                        this.currentClassName = name;
                    }

                    public MethodVisitor visitMethod(int access, String currentMethod, String descriptor, String signature, String[] exceptions) {
                        String returnType;
                        MethodVisitor visitor = super.visitMethod(access, currentMethod, descriptor, signature, exceptions);
                        if (this.currentClassName.contains("CGLIB$$")) {
                            return visitor;
                        }
                        switch (returnType = Type.getReturnType((String)descriptor).getInternalName()) {
                            case "reactor/core/publisher/Flux": 
                            case "reactor/core/publisher/Mono": 
                            case "reactor/core/publisher/ParallelFlux": {
                                visitor = new ReturnHandlingMethodVisitor(visitor, returnType, this.currentClassName, currentMethod, this.currentSource, changed);
                            }
                        }
                        return new CallSiteInfoAddingMethodVisitor(visitor, this.currentClassName, currentMethod, this.currentSource, changed);
                    }
                };
                try {
                    cr.accept(classVisitor, 0);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw e;
                }
                if (!changed.get()) {
                    return null;
                }
                return cw.toByteArray();
            }
        };
        instrumentation.addTransformer(transformer, true);
    }

    public static synchronized void processExistingClasses() {
        if (instrumentation == null) {
            throw new IllegalStateException("Must be initialized first!");
        }
        try {
            Class[] classes = (Class[])Stream.of(instrumentation.getInitiatedClasses(ClassLoader.getSystemClassLoader())).filter(aClass -> {
                try {
                    if (aClass.getClassLoader() == null) {
                        return false;
                    }
                    if (aClass.isPrimitive() || aClass.isArray() || aClass.isInterface()) {
                        return false;
                    }
                    if (aClass.isAnnotation() || aClass.isSynthetic()) {
                        return false;
                    }
                    String name = aClass.getName();
                    if (name == null) {
                        return false;
                    }
                    if (name.startsWith("[")) {
                        return false;
                    }
                    if (name.startsWith("java.")) {
                        return false;
                    }
                    if (name.startsWith("sun.")) {
                        return false;
                    }
                    if (name.startsWith("com.sun.")) {
                        return false;
                    }
                    if (name.startsWith("jdk.")) {
                        return false;
                    }
                    if (name.startsWith("reactor.core.")) {
                        return false;
                    }
                    aClass.getConstructors();
                }
                catch (LinkageError e) {
                    return false;
                }
                return true;
            }).toArray(Class[]::new);
            instrumentation.retransformClasses(classes);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

