/*
 * Decompiled with CFR 0.152.
 */
package reactor.tools.agent;

import java.util.concurrent.atomic.AtomicBoolean;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import reactor.tools.agent.CallSiteInfoAddingMethodVisitor;
import reactor.tools.agent.ReturnHandlingMethodVisitor;

class ReactorDebugClassVisitor
extends ClassVisitor {
    private final AtomicBoolean changed;
    private String currentClassName;
    private String currentSource;

    ReactorDebugClassVisitor(ClassVisitor classVisitor, AtomicBoolean changed) {
        super(458752, classVisitor);
        this.changed = changed;
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.currentSource = source;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.currentClassName = name;
    }

    public MethodVisitor visitMethod(int access, String currentMethod, String descriptor, String signature, String[] exceptions) {
        String returnType;
        MethodVisitor visitor = super.visitMethod(access, currentMethod, descriptor, signature, exceptions);
        if (this.currentClassName.contains("CGLIB$$")) {
            return visitor;
        }
        switch (returnType = Type.getReturnType((String)descriptor).getInternalName()) {
            case "reactor/core/publisher/Flux": 
            case "reactor/core/publisher/Mono": 
            case "reactor/core/publisher/ParallelFlux": {
                visitor = new ReturnHandlingMethodVisitor(visitor, returnType, this.currentClassName, currentMethod, this.currentSource, this.changed);
            }
        }
        return new CallSiteInfoAddingMethodVisitor(visitor, this.currentClassName, currentMethod, this.currentSource, this.changed);
    }
}

