/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import reactor.io.buffer.Buffer;
import reactor.io.codec.StringCodec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorChannelHandler;
import reactor.io.net.impl.netty.NettyChannelStream;
import reactor.io.net.impl.netty.http.NettyHttpClientHandler;

public class NettyHttpWSClientHandler<IN, OUT>
extends NettyHttpClientHandler<IN, OUT> {
    private final WebSocketClientHandshaker handshaker;
    private final boolean plainText;

    public NettyHttpWSClientHandler(ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler, NettyChannelStream<IN, OUT> tcpStream, WebSocketClientHandshaker handshaker) {
        super(handler, tcpStream);
        this.handshaker = handshaker;
        this.plainText = tcpStream.getEncoder() instanceof StringCodec.StringEncoder;
    }

    @Override
    protected ChannelFuture writeFirst(ChannelHandlerContext ctx) {
        return ctx.newSucceededFuture();
    }

    @Override
    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        this.handshaker.handshake(ctx.channel()).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                ctx.read();
            }
        });
    }

    @Override
    protected void writeLast(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)new CloseWebSocketFrame());
    }

    @Override
    protected void postRead(ChannelHandlerContext ctx, Object msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Class<?> messageClass = msg.getClass();
        if (!this.handshaker.isHandshakeComplete()) {
            this.handshaker.finishHandshake(ctx.channel(), (FullHttpResponse)msg);
            NettyHttpWSClientHandler.super.channelActive(ctx);
            super.channelRead(ctx, msg);
            return;
        }
        if (TextWebSocketFrame.class.isAssignableFrom(messageClass)) {
            try {
                Buffer buffer = Buffer.wrap((String)((TextWebSocketFrame)msg).text());
                if (this.channelStream.getDecoder() == null) {
                    this.channelSubscription.onNext((Object)buffer);
                    return;
                }
                Object d = this.channelStream.getDecoder().apply((Object)buffer);
                if (d == null) return;
                this.channelSubscription.onNext(d);
                return;
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        } else if (CloseWebSocketFrame.class.isAssignableFrom(messageClass)) {
            ctx.close();
            return;
        } else {
            this.doRead(ctx, ((WebSocketFrame)msg).content());
        }
    }

    @Override
    protected ChannelFuture doOnWrite(Object data, ChannelHandlerContext ctx) {
        if (data.getClass().equals(Buffer.class)) {
            if (!this.plainText) {
                return ctx.write((Object)new BinaryWebSocketFrame(NettyHttpWSClientHandler.convertBufferToByteBuff(ctx, (Buffer)data)));
            }
            return ctx.write((Object)new TextWebSocketFrame(NettyHttpWSClientHandler.convertBufferToByteBuff(ctx, (Buffer)data)));
        }
        return ctx.write(data);
    }

    @Override
    protected void doOnTerminate(ChannelHandlerContext ctx, ChannelFuture last, final ChannelPromise promise) {
        if (ctx.channel().isOpen()) {
            ChannelFutureListener listener = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        promise.trySuccess();
                    } else {
                        promise.tryFailure(future.cause());
                    }
                }
            };
            if (last != null) {
                ctx.flush();
                last.addListener((GenericFutureListener)listener);
            } else {
                ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)listener);
            }
        } else {
            promise.trySuccess();
        }
    }
}

