/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.tcp;

import java.net.InetSocketAddress;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorClient;
import reactor.io.net.config.ClientSocketOptions;
import reactor.io.net.config.SslOptions;

public abstract class TcpClient<IN, OUT>
extends ReactorClient<IN, OUT, ChannelStream<IN, OUT>> {
    private final InetSocketAddress connectAddress;
    private final ClientSocketOptions options;
    private final SslOptions sslOptions;

    protected TcpClient(Environment env, Dispatcher dispatcher, InetSocketAddress connectAddress, ClientSocketOptions options, SslOptions sslOptions, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, codec, options.prefetch());
        this.connectAddress = null != connectAddress ? connectAddress : new InetSocketAddress("127.0.0.1", 3000);
        this.options = options;
        this.sslOptions = sslOptions;
    }

    public InetSocketAddress getConnectAddress() {
        return this.connectAddress;
    }

    protected ClientSocketOptions getOptions() {
        return this.options;
    }

    protected SslOptions getSslOptions() {
        return this.sslOptions;
    }
}

