/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.udp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.support.Assert;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorPeer;
import reactor.io.net.config.ServerSocketOptions;
import reactor.rx.Promise;

public abstract class DatagramServer<IN, OUT>
extends ReactorPeer<IN, OUT, ChannelStream<IN, OUT>> {
    private final InetSocketAddress listenAddress;
    private final NetworkInterface multicastInterface;
    private final ServerSocketOptions options;

    protected DatagramServer(Environment env, Dispatcher dispatcher, InetSocketAddress listenAddress, NetworkInterface multicastInterface, ServerSocketOptions options, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, codec, options.prefetch());
        Assert.notNull((Object)options, (String)"ServerSocketOptions cannot be null");
        this.listenAddress = listenAddress;
        this.multicastInterface = multicastInterface;
        this.options = options;
    }

    public abstract Promise<Void> join(InetAddress var1, NetworkInterface var2);

    public Promise<Void> join(InetAddress multicastAddress) {
        return this.join(multicastAddress, null);
    }

    public abstract Promise<Void> leave(InetAddress var1, NetworkInterface var2);

    public Promise<Void> leave(InetAddress multicastAddress) {
        return this.leave(multicastAddress, null);
    }

    protected InetSocketAddress getListenAddress() {
        return this.listenAddress;
    }

    protected NetworkInterface getMulticastInterface() {
        return this.multicastInterface;
    }

    protected ServerSocketOptions getOptions() {
        return this.options;
    }
}

