/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.http;

import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.io.buffer.Buffer;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorChannelHandler;
import reactor.io.net.http.HttpException;
import reactor.io.net.http.model.Method;
import reactor.io.net.impl.netty.NettyChannelHandlerBridge;
import reactor.io.net.impl.netty.NettyChannelStream;
import reactor.io.net.impl.netty.http.NettyHttpChannel;
import reactor.rx.action.support.DefaultSubscriber;

public class NettyHttpClientHandler<IN, OUT>
extends NettyChannelHandlerBridge<IN, OUT> {
    private final NettyChannelStream<IN, OUT> tcpStream;
    private final Buffer body;
    protected NettyHttpChannel<IN, OUT> request;

    public NettyHttpClientHandler(ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler, NettyChannelStream<IN, OUT> tcpStream) {
        super(handler, tcpStream);
        this.tcpStream = tcpStream;
        this.body = new Buffer();
    }

    @Override
    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
        this.request = new NettyHttpChannel<IN, OUT>(this.tcpStream, (HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/"));
        this.request.keepAlive(true);
        ((Publisher)this.handler.apply(this.request)).subscribe((Subscriber)new DefaultSubscriber<Void>(){

            public void onSubscribe(final Subscription s) {
                if (NettyHttpClientHandler.this.request.checkHeader()) {
                    NettyHttpClientHandler.this.writeFirst(ctx).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                s.request(Long.MAX_VALUE);
                            } else {
                                log.error("Error processing initial headers. Closing the channel.", future.cause());
                                s.cancel();
                                if (ctx.channel().isOpen()) {
                                    ctx.channel().close();
                                }
                            }
                        }
                    });
                } else {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onError(Throwable t) {
                log.error("Error processing connection. Closing the channel.", t);
                if (ctx.channel().isOpen()) {
                    ctx.channel().close();
                }
            }

            public void onComplete() {
                NettyHttpClientHandler.this.writeLast(ctx);
            }
        });
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Class<?> messageClass = msg.getClass();
        if (HttpResponse.class.isAssignableFrom(messageClass)) {
            HttpResponse response = (HttpResponse)msg;
            if (this.request != null) {
                this.request.setNettyResponse(response);
            }
            this.checkResponseCode(ctx, response);
            if (FullHttpResponse.class.isAssignableFrom(messageClass)) {
                this.postRead(ctx, msg);
            }
        } else if (HttpContent.class.isAssignableFrom(messageClass)) {
            super.channelRead(ctx, ((ByteBufHolder)msg).content());
            this.postRead(ctx, msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    private void checkResponseCode(ChannelHandlerContext ctx, HttpResponse response) throws Exception {
        boolean discardBody = false;
        int code = response.getStatus().code();
        if (code == HttpResponseStatus.NOT_FOUND.code() || code == HttpResponseStatus.BAD_REQUEST.code()) {
            this.exceptionCaught(ctx, new HttpException(response.getStatus()));
            discardBody = true;
        }
        this.setDiscardBody(discardBody);
    }

    protected void postRead(ChannelHandlerContext ctx, Object msg) {
        if (LastHttpContent.class.isAssignableFrom(msg.getClass())) {
            ctx.channel().close();
        }
    }

    protected ChannelFuture writeFirst(ChannelHandlerContext ctx) {
        return ctx.writeAndFlush((Object)this.request.getNettyRequest());
    }

    protected void writeLast(ChannelHandlerContext ctx) {
        ctx.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
    }

    @Override
    protected ChannelFuture doOnWrite(Object data, ChannelHandlerContext ctx) {
        if (data.getClass().equals(Buffer.class)) {
            this.body.append(new Buffer[]{(Buffer)data});
            return null;
        }
        return ctx.write(data);
    }

    @Override
    protected void doOnTerminate(ChannelHandlerContext ctx, ChannelFuture last, final ChannelPromise promise) {
        if (this.request.method() == Method.WS) {
            return;
        }
        ByteBuffer byteBuffer = this.body.flip().byteBuffer();
        if (this.request.checkHeader()) {
            DefaultFullHttpRequest req = new DefaultFullHttpRequest(this.request.getNettyRequest().getProtocolVersion(), this.request.getNettyRequest().getMethod(), this.request.getNettyRequest().getUri(), byteBuffer != null ? Unpooled.wrappedBuffer((ByteBuffer)byteBuffer) : Unpooled.EMPTY_BUFFER);
            if (byteBuffer != null) {
                HttpHeaders.setContentLength((HttpMessage)req, (long)this.body.limit());
                String header = HttpHeaders.getHeader((HttpMessage)this.request.getNettyRequest(), (String)"Content-Type");
                if (header != null) {
                    HttpHeaders.setHeader((HttpMessage)req, (String)"Content-Type", (Object)header);
                }
            }
            ctx.writeAndFlush((Object)req).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        promise.trySuccess();
                    } else {
                        promise.tryFailure(future.cause());
                    }
                }
            });
        } else {
            ctx.write((Object)new DefaultHttpContent(byteBuffer != null ? Unpooled.wrappedBuffer((ByteBuffer)byteBuffer) : Unpooled.EMPTY_BUFFER));
        }
        this.body.reset();
    }
}

