/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.http;

import reactor.bus.selector.HeaderResolver;
import reactor.bus.selector.Selector;
import reactor.bus.selector.UriPathSelector;
import reactor.io.net.http.HttpChannel;
import reactor.io.net.http.model.Method;
import reactor.io.net.http.model.Protocol;

public class HttpSelector
implements Selector<HttpChannel> {
    protected final Protocol protocol;
    protected final Method method;
    protected final UriPathSelector uriPathSelector;

    public HttpSelector(String uri) {
        this(uri, null, null);
    }

    public HttpSelector(String uri, Protocol protocol, Method method) {
        this.protocol = protocol;
        this.method = method;
        this.uriPathSelector = uri != null && !uri.isEmpty() ? new UriPathSelector(uri) : null;
    }

    public Object getObject() {
        return null;
    }

    public HeaderResolver getHeaderResolver() {
        return this.uriPathSelector != null ? this.uriPathSelector.getHeaderResolver() : null;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Method getMethod() {
        return this.method;
    }

    public UriPathSelector getUriPathSelector() {
        return this.uriPathSelector;
    }

    public boolean matches(HttpChannel key) {
        return !(this.protocol != null && !this.protocol.equals((Object)key.protocol()) || this.method != null && !this.method.equals(key.method()) || this.uriPathSelector != null && !this.uriPathSelector.matches(key.uri()));
    }
}

