/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net;

import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.Environment;
import reactor.bus.spec.DispatcherComponentSpec;
import reactor.core.Dispatcher;
import reactor.core.support.Assert;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.fn.Supplier;
import reactor.fn.Suppliers;
import reactor.fn.tuple.Tuple;
import reactor.fn.tuple.Tuple2;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorPeer;
import reactor.io.net.Reconnect;
import reactor.io.net.config.ClientSocketOptions;
import reactor.io.net.config.ServerSocketOptions;
import reactor.io.net.config.SslOptions;
import reactor.io.net.http.HttpChannel;
import reactor.io.net.http.HttpClient;
import reactor.io.net.http.HttpServer;
import reactor.io.net.tcp.TcpClient;
import reactor.io.net.tcp.TcpServer;
import reactor.io.net.udp.DatagramServer;

public interface Spec {
    public static final Function NOOP_DECODER = new Function(){

        public Object apply(Object o) {
            return o;
        }
    };
    public static final Codec NOOP_CODEC = new Codec(){

        public Function decoder(Consumer next) {
            return NOOP_DECODER;
        }

        public Object apply(Object o) {
            return o;
        }
    };

    public static class IncrementalBackoffReconnect
    implements Supplier<Reconnect> {
        public static final long DEFAULT_INTERVAL = 5000L;
        public static final long DEFAULT_MULTIPLIER = 1L;
        public static final long DEFAULT_MAX_ATTEMPTS = -1L;
        private final List<InetSocketAddress> addresses = new LinkedList<InetSocketAddress>();
        private long interval = 5000L;
        private long multiplier = 1L;
        private long maxInterval = Long.MAX_VALUE;
        private long maxAttempts = -1L;

        IncrementalBackoffReconnect() {
        }

        public IncrementalBackoffReconnect interval(long interval) {
            this.interval = interval;
            return this;
        }

        public IncrementalBackoffReconnect maxInterval(long maxInterval) {
            this.maxInterval = maxInterval;
            return this;
        }

        public IncrementalBackoffReconnect multiplier(long multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public IncrementalBackoffReconnect maxAttempts(long maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public IncrementalBackoffReconnect address(InetSocketAddress address) {
            this.addresses.add(address);
            return this;
        }

        public IncrementalBackoffReconnect address(String host, int port) {
            this.addresses.add(new InetSocketAddress(host, port));
            return this;
        }

        public Reconnect get() {
            final Supplier endpoints = Suppliers.roundRobin((Object[])this.addresses.toArray(new InetSocketAddress[0]));
            return new Reconnect(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Tuple2<InetSocketAddress, Long> reconnect(InetSocketAddress currentAddress, int attempt) {
                    Tuple2 rv = null;
                    IncrementalBackoffReconnect incrementalBackoffReconnect = IncrementalBackoffReconnect.this;
                    synchronized (incrementalBackoffReconnect) {
                        if (!IncrementalBackoffReconnect.this.addresses.isEmpty()) {
                            if (IncrementalBackoffReconnect.this.maxAttempts == -1L || IncrementalBackoffReconnect.this.maxAttempts > (long)attempt) {
                                rv = Tuple.of((Object)endpoints.get(), (Object)IncrementalBackoffReconnect.this.determineInterval(attempt));
                            }
                        } else {
                            rv = Tuple.of((Object)currentAddress, (Object)IncrementalBackoffReconnect.this.determineInterval(attempt));
                        }
                    }
                    return rv;
                }
            };
        }

        public long determineInterval(int attempt) {
            return this.multiplier > 1L ? Math.min(this.maxInterval, this.interval * (long)attempt) : this.interval;
        }
    }

    public static class HttpClientSpec<IN, OUT>
    extends DispatcherComponentSpec<HttpClientSpec<IN, OUT>, HttpClient<IN, OUT>> {
        private final Constructor<HttpClient> clientImplConstructor;
        private InetSocketAddress connectAddress;
        private ClientSocketOptions options = new ClientSocketOptions();
        private SslOptions sslOptions = null;
        private Codec<Buffer, IN, OUT> codec;

        HttpClientSpec(@Nonnull Class<? extends HttpClient> clientImpl) {
            Assert.notNull(clientImpl, (String)"TcpClient implementation class cannot be null.");
            try {
                this.clientImplConstructor = clientImpl.getDeclaredConstructor(Environment.class, Dispatcher.class, InetSocketAddress.class, ClientSocketOptions.class, SslOptions.class, Codec.class);
                this.clientImplConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No public constructor found that matches the signature of the one found in the TcpClient class.");
            }
        }

        public HttpClientSpec<IN, OUT> options(ClientSocketOptions options) {
            this.options = options;
            return this;
        }

        public HttpClientSpec<IN, OUT> ssl(@Nullable SslOptions sslOptions) {
            this.sslOptions = sslOptions;
            return this;
        }

        public HttpClientSpec<IN, OUT> connect(@Nonnull String host, int port) {
            return this.connect(new InetSocketAddress(host, port));
        }

        public HttpClientSpec<IN, OUT> connect(@Nonnull InetSocketAddress connectAddress) {
            Assert.isNull((Object)this.connectAddress, (String)"Connect address is already set.");
            this.connectAddress = connectAddress;
            return this;
        }

        public HttpClientSpec<IN, OUT> codec(@Nullable Codec<Buffer, IN, OUT> codec) {
            Assert.isNull(this.codec, (String)"Codec has already been set.");
            this.codec = codec;
            return this;
        }

        protected HttpClient<IN, OUT> configure(Dispatcher dispatcher, Environment environment) {
            try {
                return this.clientImplConstructor.newInstance(environment, dispatcher, this.connectAddress, this.options, this.sslOptions, this.codec);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    public static class HttpServerSpec<IN, OUT>
    extends PeerSpec<IN, OUT, HttpChannel<IN, OUT>, HttpServerSpec<IN, OUT>, HttpServer<IN, OUT>> {
        private final Constructor<? extends HttpServer> serverImplConstructor;
        private SslOptions sslOptions = null;

        HttpServerSpec(@Nonnull Class<? extends HttpServer> serverImpl) {
            Assert.notNull(serverImpl, (String)"TcpServer implementation class cannot be null.");
            try {
                this.serverImplConstructor = serverImpl.getDeclaredConstructor(Environment.class, Dispatcher.class, InetSocketAddress.class, ServerSocketOptions.class, SslOptions.class, Codec.class);
                this.serverImplConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No public constructor found that matches the signature of the one found in the TcpServer class.");
            }
        }

        public HttpServerSpec<IN, OUT> ssl(@Nullable SslOptions sslOptions) {
            this.sslOptions = sslOptions;
            return this;
        }

        protected HttpServer<IN, OUT> configure(Dispatcher dispatcher, Environment env) {
            try {
                return this.serverImplConstructor.newInstance(env, dispatcher, this.listenAddress, this.options, this.sslOptions, this.codec);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    public static class DatagramServerSpec<IN, OUT>
    extends PeerSpec<IN, OUT, ChannelStream<IN, OUT>, DatagramServerSpec<IN, OUT>, DatagramServer<IN, OUT>> {
        protected final Constructor<? extends DatagramServer> serverImplCtor;
        private NetworkInterface multicastInterface;

        DatagramServerSpec(Class<? extends DatagramServer> serverImpl) {
            Assert.notNull(serverImpl, (String)"NetServer implementation class cannot be null.");
            try {
                this.serverImplCtor = serverImpl.getDeclaredConstructor(Environment.class, Dispatcher.class, InetSocketAddress.class, NetworkInterface.class, ServerSocketOptions.class, Codec.class);
                this.serverImplCtor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No public constructor found that matches the signature of the one found in the DatagramServer class.");
            }
        }

        public DatagramServerSpec<IN, OUT> multicastInterface(NetworkInterface iface) {
            this.multicastInterface = iface;
            return this;
        }

        protected DatagramServer<IN, OUT> configure(Dispatcher dispatcher, Environment environment) {
            try {
                return this.serverImplCtor.newInstance(environment, dispatcher, this.listenAddress, this.multicastInterface, this.options, this.codec);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    public static class TcpServerSpec<IN, OUT>
    extends PeerSpec<IN, OUT, ChannelStream<IN, OUT>, TcpServerSpec<IN, OUT>, TcpServer<IN, OUT>> {
        private final Constructor<? extends TcpServer> serverImplConstructor;
        private SslOptions sslOptions = null;

        TcpServerSpec(@Nonnull Class<? extends TcpServer> serverImpl) {
            Assert.notNull(serverImpl, (String)"TcpServer implementation class cannot be null.");
            try {
                this.serverImplConstructor = serverImpl.getDeclaredConstructor(Environment.class, Dispatcher.class, InetSocketAddress.class, ServerSocketOptions.class, SslOptions.class, Codec.class);
                this.serverImplConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No public constructor found that matches the signature of the one found in the TcpServer class.");
            }
        }

        public TcpServerSpec<IN, OUT> ssl(@Nullable SslOptions sslOptions) {
            this.sslOptions = sslOptions;
            return this;
        }

        protected TcpServer<IN, OUT> configure(Dispatcher dispatcher, Environment env) {
            try {
                return this.serverImplConstructor.newInstance(env, dispatcher, this.listenAddress, this.options, this.sslOptions, this.codec);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    public static class TcpClientSpec<IN, OUT>
    extends DispatcherComponentSpec<TcpClientSpec<IN, OUT>, TcpClient<IN, OUT>> {
        private final Constructor<TcpClient> clientImplConstructor;
        private InetSocketAddress connectAddress;
        private ClientSocketOptions options = new ClientSocketOptions();
        private SslOptions sslOptions = null;
        private Codec<Buffer, IN, OUT> codec;

        TcpClientSpec(@Nonnull Class<? extends TcpClient> clientImpl) {
            Assert.notNull(clientImpl, (String)"TcpClient implementation class cannot be null.");
            try {
                this.clientImplConstructor = clientImpl.getDeclaredConstructor(Environment.class, Dispatcher.class, InetSocketAddress.class, ClientSocketOptions.class, SslOptions.class, Codec.class);
                this.clientImplConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No public constructor found that matches the signature of the one found in the TcpClient class.");
            }
        }

        public TcpClientSpec<IN, OUT> options(ClientSocketOptions options) {
            this.options = options;
            return this;
        }

        public TcpClientSpec<IN, OUT> ssl(@Nullable SslOptions sslOptions) {
            this.sslOptions = sslOptions;
            return this;
        }

        public TcpClientSpec<IN, OUT> connect(@Nonnull String host, int port) {
            return this.connect(new InetSocketAddress(host, port));
        }

        public TcpClientSpec<IN, OUT> connect(@Nonnull InetSocketAddress connectAddress) {
            Assert.isNull((Object)this.connectAddress, (String)"Connect address is already set.");
            this.connectAddress = connectAddress;
            return this;
        }

        public TcpClientSpec<IN, OUT> codec(@Nullable Codec<Buffer, IN, OUT> codec) {
            Assert.isNull(this.codec, (String)"Codec has already been set.");
            this.codec = codec;
            return this;
        }

        public TcpClientSpec<IN, OUT> rawData(boolean israw) {
            if (israw) {
                this.codec = NOOP_CODEC;
            }
            return this;
        }

        protected TcpClient<IN, OUT> configure(Dispatcher dispatcher, Environment environment) {
            try {
                return this.clientImplConstructor.newInstance(environment, dispatcher, this.connectAddress, this.options, this.sslOptions, this.codec);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    public static abstract class PeerSpec<IN, OUT, CONN extends ChannelStream<IN, OUT>, S extends PeerSpec<IN, OUT, CONN, S, N>, N extends ReactorPeer<IN, OUT, CONN>>
    extends DispatcherComponentSpec<S, N> {
        protected ServerSocketOptions options = new ServerSocketOptions();
        protected InetSocketAddress listenAddress;
        protected Codec<Buffer, IN, OUT> codec;

        public S options(@Nonnull ServerSocketOptions options) {
            Assert.notNull((Object)options, (String)"ServerSocketOptions cannot be null.");
            this.options = options;
            return (S)((Object)this);
        }

        public S listen(int port) {
            return this.listen(new InetSocketAddress(port));
        }

        public S listen(String host, int port) {
            if (null == host) {
                host = "localhost";
            }
            return this.listen(new InetSocketAddress(host, port));
        }

        public S listen(InetSocketAddress listenAddress) {
            this.listenAddress = listenAddress;
            return (S)((Object)this);
        }

        public S codec(@Nonnull Codec<Buffer, IN, OUT> codec) {
            Assert.notNull(codec, (String)"Codec cannot be null.");
            this.codec = codec;
            return (S)((Object)this);
        }

        public S rawData(boolean israw) {
            if (israw) {
                this.codec = NOOP_CODEC;
            }
            return (S)((Object)this);
        }
    }
}

