/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.support.NamedDaemonThreadFactory;
import reactor.fn.Consumer;
import reactor.fn.Supplier;
import reactor.fn.tuple.Tuple;
import reactor.fn.tuple.Tuple2;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorChannelHandler;
import reactor.io.net.Reconnect;
import reactor.io.net.config.ClientSocketOptions;
import reactor.io.net.config.SslOptions;
import reactor.io.net.impl.netty.NettyChannelHandlerBridge;
import reactor.io.net.impl.netty.NettyChannelStream;
import reactor.io.net.impl.netty.NettyClientSocketOptions;
import reactor.io.net.tcp.TcpClient;
import reactor.io.net.tcp.ssl.SSLEngineSupplier;
import reactor.rx.Promise;
import reactor.rx.Promises;
import reactor.rx.Stream;
import reactor.rx.broadcast.BehaviorBroadcaster;
import reactor.rx.broadcast.Broadcaster;

public class NettyTcpClient<IN, OUT>
extends TcpClient<IN, OUT> {
    private static final Logger log = LoggerFactory.getLogger(NettyTcpClient.class);
    private final NettyClientSocketOptions nettyOptions;
    private final Bootstrap bootstrap;
    private final EventLoopGroup ioGroup;
    private final Supplier<ChannelFuture> connectionSupplier;
    private volatile InetSocketAddress connectAddress;

    public NettyTcpClient(Environment env, Dispatcher dispatcher, InetSocketAddress connectAddress, ClientSocketOptions options, SslOptions sslOptions, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, connectAddress, options, sslOptions, codec);
        this.connectAddress = connectAddress;
        this.nettyOptions = options instanceof NettyClientSocketOptions ? (NettyClientSocketOptions)options : null;
        if (null != this.nettyOptions && null != this.nettyOptions.eventLoopGroup()) {
            this.ioGroup = this.nettyOptions.eventLoopGroup();
        } else {
            int ioThreadCount = env != null ? (Integer)env.getProperty("reactor.tcp.ioThreadCount", Integer.class, (Object)Environment.PROCESSORS) : Environment.PROCESSORS;
            this.ioGroup = new NioEventLoopGroup(ioThreadCount, (ThreadFactory)new NamedDaemonThreadFactory("reactor-tcp-io"));
        }
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.ioGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_RCVBUF, (Object)options.rcvbuf())).option(ChannelOption.SO_SNDBUF, (Object)options.sndbuf())).option(ChannelOption.SO_KEEPALIVE, (Object)options.keepAlive())).option(ChannelOption.SO_LINGER, (Object)options.linger())).option(ChannelOption.TCP_NODELAY, (Object)options.tcpNoDelay())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.AUTO_READ, (Object)(sslOptions != null ? 1 : 0));
        this.connectionSupplier = new Supplier<ChannelFuture>(){

            public ChannelFuture get() {
                if (NettyTcpClient.this.started.get()) {
                    return NettyTcpClient.this.bootstrap.connect((SocketAddress)NettyTcpClient.this.getConnectAddress());
                }
                return null;
            }
        };
    }

    @Override
    protected Promise<Void> doStart(ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler) {
        final Promise promise = Promises.prepare();
        ChannelFutureListener listener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    promise.onComplete();
                } else {
                    promise.onError(future.cause());
                }
            }
        };
        this.addHandler(handler);
        this.openChannel(listener);
        return promise;
    }

    private void addHandler(ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler) {
        final ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> targetHandler = null == handler ? PING : handler;
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.config().setConnectTimeoutMillis(NettyTcpClient.this.getOptions().timeout());
                if (null != NettyTcpClient.this.getSslOptions()) {
                    SSLEngine ssl = new SSLEngineSupplier(NettyTcpClient.this.getSslOptions(), true).get();
                    if (log.isDebugEnabled()) {
                        log.debug("SSL enabled using keystore {}", (Object)(null != NettyTcpClient.this.getSslOptions().keystoreFile() ? NettyTcpClient.this.getSslOptions().keystoreFile() : "<DEFAULT>"));
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(ssl)});
                } else {
                    ch.config().setAutoRead(false);
                }
                if (null != NettyTcpClient.this.nettyOptions && null != NettyTcpClient.this.nettyOptions.pipelineConfigurer()) {
                    NettyTcpClient.this.nettyOptions.pipelineConfigurer().accept((Object)ch.pipeline());
                }
                NettyTcpClient.this.bindChannel(targetHandler, ch);
            }
        });
    }

    @Override
    protected Stream<Tuple2<InetSocketAddress, Integer>> doStart(ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler, Reconnect reconnect) {
        ReconnectingChannelListener listener = new ReconnectingChannelListener(this.connectAddress, reconnect);
        this.addHandler(handler);
        this.openChannel(listener);
        return listener.broadcaster;
    }

    @Override
    protected Promise<Void> doShutdown() {
        if (this.nettyOptions != null && this.nettyOptions.eventLoopGroup() != null) {
            return Promises.success();
        }
        final Promise promise = Promises.prepare();
        this.ioGroup.shutdownGracefully().addListener((GenericFutureListener)new FutureListener<Object>(){

            public void operationComplete(Future<Object> future) throws Exception {
                if (future.isDone() && future.isSuccess()) {
                    promise.onComplete();
                } else {
                    promise.onError(future.cause());
                }
            }
        });
        return promise;
    }

    protected void bindChannel(ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler, Object nativeChannel) {
        SocketChannel ch = (SocketChannel)nativeChannel;
        NettyChannelStream netChannel = new NettyChannelStream(this.getDefaultEnvironment(), this.getDefaultCodec(), this.getDefaultPrefetchSize(), this.getDefaultDispatcher(), (Channel)ch);
        ChannelPipeline pipeline = ch.pipeline();
        if (log.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(NettyTcpClient.class)});
        }
        pipeline.addLast(new ChannelHandler[]{new NettyChannelHandlerBridge<IN, OUT>(handler, netChannel)});
    }

    private void openChannel(ChannelFutureListener listener) {
        ChannelFuture channel = (ChannelFuture)this.connectionSupplier.get();
        if (null != channel && null != listener) {
            channel.addListener((GenericFutureListener)listener);
        }
    }

    private class ReconnectingChannelListener
    implements ChannelFutureListener {
        private final AtomicInteger attempts = new AtomicInteger(0);
        private final Reconnect reconnect;
        private final Broadcaster<Tuple2<InetSocketAddress, Integer>> broadcaster = BehaviorBroadcaster.create((Environment)NettyTcpClient.this.getDefaultEnvironment(), (Dispatcher)NettyTcpClient.this.getDefaultDispatcher());
        private volatile InetSocketAddress connectAddress;

        private ReconnectingChannelListener(InetSocketAddress connectAddress, Reconnect reconnect) {
            this.connectAddress = connectAddress;
            this.reconnect = reconnect;
        }

        public void operationComplete(final ChannelFuture future) throws Exception {
            this.broadcaster.onNext((Object)Tuple.of((Object)this.connectAddress, (Object)this.attempts.get()));
            if (!future.isSuccess()) {
                int attempt = this.attempts.incrementAndGet();
                Tuple2<InetSocketAddress, Long> tup = this.reconnect.reconnect(this.connectAddress, attempt);
                if (null == tup) {
                    if (log.isErrorEnabled()) {
                        log.error("Reconnection to {} failed after {} attempts. Giving up.", (Object)this.connectAddress, (Object)(attempt - 1));
                    }
                    future.channel().eventLoop().submit(new Runnable(){

                        @Override
                        public void run() {
                            ReconnectingChannelListener.this.broadcaster.onError(future.cause());
                        }
                    });
                    return;
                }
                this.attemptReconnect(tup);
            } else {
                if (log.isInfoEnabled()) {
                    log.info("CONNECTED: " + future.channel());
                }
                final Channel ioCh = future.channel();
                ioCh.pipeline().addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        Tuple2<InetSocketAddress, Long> tup;
                        if (log.isInfoEnabled()) {
                            log.info("CLOSED: " + ioCh);
                        }
                        if (null == (tup = ReconnectingChannelListener.this.reconnect.reconnect(ReconnectingChannelListener.this.connectAddress, ReconnectingChannelListener.this.attempts.incrementAndGet()))) {
                            ReconnectingChannelListener.this.broadcaster.onComplete();
                            return;
                        }
                        ReconnectingChannelListener.this.attemptReconnect((Tuple2<InetSocketAddress, Long>)tup);
                        super.channelInactive(ctx);
                    }
                }});
            }
        }

        private void attemptReconnect(Tuple2<InetSocketAddress, Long> tup) {
            this.connectAddress = (InetSocketAddress)tup.getT1();
            NettyTcpClient.this.bootstrap.remoteAddress((SocketAddress)this.connectAddress);
            long delay = (Long)tup.getT2();
            if (log.isInfoEnabled()) {
                log.info("Failed to connect to {}. Attempting reconnect in {}ms.", (Object)this.connectAddress, (Object)delay);
            }
            NettyTcpClient.this.getDefaultEnvironment().getTimer().submit((Consumer)new Consumer<Long>(){

                public void accept(Long now) {
                    NettyTcpClient.this.openChannel(ReconnectingChannelListener.this);
                }
            }, delay, TimeUnit.MILLISECONDS);
        }
    }
}

