/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorChannelHandler;
import reactor.io.net.config.ServerSocketOptions;
import reactor.io.net.config.SslOptions;
import reactor.io.net.http.HttpChannel;
import reactor.io.net.http.HttpServer;
import reactor.io.net.impl.netty.NettyChannelStream;
import reactor.io.net.impl.netty.http.NettyHttpChannel;
import reactor.io.net.impl.netty.http.NettyHttpServerHandler;
import reactor.io.net.impl.netty.tcp.NettyTcpServer;
import reactor.io.net.tcp.TcpServer;
import reactor.rx.Promise;
import reactor.rx.Streams;

public class NettyHttpServer<IN, OUT>
extends HttpServer<IN, OUT> {
    private static final Logger log = LoggerFactory.getLogger(NettyHttpServer.class);
    protected final TcpServer<IN, OUT> server;

    protected NettyHttpServer(Environment env, Dispatcher dispatcher, InetSocketAddress listenAddress, ServerSocketOptions options, SslOptions sslOptions, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, codec);
        this.server = new NettyTcpServer<IN, OUT>(env, dispatcher, listenAddress, options, sslOptions, codec){

            @Override
            protected void bindChannel(ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler, Object nativeChannel) {
                NettyHttpServer.this.bindChannel(handler, nativeChannel);
            }
        };
    }

    @Override
    public InetSocketAddress getListenAddress() {
        return this.server.getListenAddress();
    }

    @Override
    protected Promise<Void> doStart(final ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        return this.server.start(new ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>>(){

            public Publisher<Void> apply(ChannelStream<IN, OUT> ch) {
                Iterable<Publisher<Void>> handlers;
                NettyHttpChannel request = (NettyHttpChannel)ch;
                if (handler != null) {
                    handler.apply(request);
                }
                if ((handlers = NettyHttpServer.this.routeChannel(request)) == null) {
                    if (request.checkHeader()) {
                        request.delegate().writeAndFlush((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND));
                    }
                    return Streams.empty();
                }
                return Streams.concat(handlers);
            }
        });
    }

    @Override
    protected Iterable<? extends Publisher<Void>> routeChannel(HttpChannel<IN, OUT> ch) {
        Iterable<Publisher<Void>> handlers = super.routeChannel(ch);
        if (!handlers.iterator().hasNext()) {
            return null;
        }
        return handlers;
    }

    @Override
    protected final Promise<Void> doShutdown() {
        return this.server.shutdown();
    }

    protected void bindChannel(ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler, Object nativeChannel) {
        SocketChannel ch = (SocketChannel)nativeChannel;
        NettyChannelStream netChannel = new NettyChannelStream(this.getDefaultEnvironment(), this.getDefaultCodec(), this.getDefaultPrefetchSize(), this.getDefaultDispatcher(), (Channel)ch);
        ChannelPipeline pipeline = ch.pipeline();
        if (log.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(NettyHttpServer.class)});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new NettyHttpServerHandler<IN, OUT>(handler, netChannel)});
    }
}

