/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.http;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NettyHttpHeaders
implements reactor.io.net.http.model.HttpHeaders {
    private final HttpRequest nettyRequest;
    private final HttpHeaders nettyHeaders;

    public NettyHttpHeaders(HttpRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
        this.nettyHeaders = nettyRequest.headers();
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders add(String name, String value) {
        this.nettyHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders add(String name, Iterable<String> values) {
        this.nettyHeaders.add(name, values);
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders addDateHeader(String name, Date value) {
        HttpHeaders.addDateHeader((HttpMessage)this.nettyRequest, (String)name, (Date)value);
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders clear() {
        this.nettyHeaders.clear();
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders remove(String name) {
        this.nettyHeaders.remove(name);
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders removeTransferEncodingChunked() {
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders set(String name, String value) {
        this.nettyHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders set(String name, Iterable<String> values) {
        this.nettyHeaders.set(name, values);
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders contentLength(long length) {
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders date(Date value) {
        HttpHeaders.setDate((HttpMessage)this.nettyRequest, (Date)value);
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders dateHeader(String name, Date value) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyRequest, (String)name, (Date)value);
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders dateHeader(String name, Iterable<Date> values) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyRequest, (String)name, values);
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders host(String value) {
        HttpHeaders.setHost((HttpMessage)this.nettyRequest, (String)value);
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders keepAlive(boolean keepAlive) {
        HttpHeaders.setKeepAlive((HttpMessage)this.nettyRequest, (boolean)keepAlive);
        return this;
    }

    @Override
    public reactor.io.net.http.model.HttpHeaders transferEncodingChunked() {
        return this;
    }

    @Override
    public boolean contains(String name) {
        return this.nettyHeaders.contains(name);
    }

    @Override
    public boolean contains(String name, String value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name, value, ignoreCaseValue);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return this.nettyHeaders.entries();
    }

    @Override
    public String get(String name) {
        return this.nettyHeaders.get(name);
    }

    @Override
    public List<String> getAll(String name) {
        return this.nettyHeaders.getAll(name);
    }

    @Override
    public Date getDate() throws ParseException {
        return HttpHeaders.getDate((HttpMessage)this.nettyRequest);
    }

    @Override
    public Date getDateHeader(String name) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, (String)name);
    }

    @Override
    public String getHost() {
        return HttpHeaders.getHost((HttpMessage)this.nettyRequest);
    }

    @Override
    public boolean isEmpty() {
        return this.nettyHeaders.isEmpty();
    }

    @Override
    public Set<String> names() {
        return this.nettyHeaders.names();
    }
}

