/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.http;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.Environment;
import reactor.bus.registry.Registration;
import reactor.bus.registry.Registries;
import reactor.bus.registry.Registry;
import reactor.bus.selector.HeaderResolver;
import reactor.bus.selector.Selector;
import reactor.core.Dispatcher;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.NetSelectors;
import reactor.io.net.ReactorChannelHandler;
import reactor.io.net.ReactorPeer;
import reactor.io.net.http.HttpChannel;
import reactor.rx.Promise;

public abstract class HttpServer<IN, OUT>
extends ReactorPeer<IN, OUT, HttpChannel<IN, OUT>> {
    protected final Registry<ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>>> routedWriters = Registries.create();

    protected HttpServer(Environment env, Dispatcher dispatcher, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, codec);
    }

    public Promise<Void> start() {
        return this.start(null);
    }

    public abstract InetSocketAddress getListenAddress();

    public HttpServer<IN, OUT> route(Selector condition, ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> serviceFunction) {
        this.routedWriters.register(condition, serviceFunction);
        return this;
    }

    public final HttpServer<IN, OUT> get(String path, ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        this.route(NetSelectors.get(path), handler);
        return this;
    }

    public final HttpServer<IN, OUT> post(String path, ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        this.route(NetSelectors.post(path), handler);
        return this;
    }

    public final HttpServer<IN, OUT> put(String path, ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        this.route(NetSelectors.put(path), handler);
        return this;
    }

    public final HttpServer<IN, OUT> delete(String path, ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        this.route(NetSelectors.delete(path), handler);
        return this;
    }

    protected Iterable<? extends Publisher<Void>> routeChannel(final HttpChannel<IN, OUT> ch) {
        final List selected = this.routedWriters.select(ch);
        return new Iterable<Publisher<Void>>(){

            @Override
            public Iterator<Publisher<Void>> iterator() {
                final Iterator iterator = selected.iterator();
                return new Iterator<Publisher<Void>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public Publisher<Void> next() {
                        Registration next = (Registration)iterator.next();
                        if (next != null) {
                            ch.paramsResolver((HeaderResolver<String>)next.getSelector().getHeaderResolver());
                            return (Publisher)((ReactorChannelHandler)next.getObject()).apply(ch);
                        }
                        return null;
                    }
                };
            }
        };
    }
}

