/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.http;

import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.Environment;
import reactor.bus.selector.HeaderResolver;
import reactor.core.Dispatcher;
import reactor.io.net.ChannelStream;
import reactor.io.net.http.model.HttpHeaders;
import reactor.io.net.http.model.Method;
import reactor.io.net.http.model.Protocol;
import reactor.io.net.http.model.ResponseHeaders;
import reactor.io.net.http.model.Status;
import reactor.io.net.http.model.Transfer;

public abstract class HttpChannel<IN, OUT>
extends ChannelStream<IN, OUT> {
    private volatile int statusAndHeadersSent = 0;
    private HeaderResolver<String> paramsResolver;
    protected static final AtomicIntegerFieldUpdater<HttpChannel> HEADERS_SENT = AtomicIntegerFieldUpdater.newUpdater(HttpChannel.class, "statusAndHeadersSent");

    public HttpChannel(Environment env, long prefetch, Dispatcher eventsDispatcher) {
        super(env, null, prefetch, eventsDispatcher);
    }

    public final Map<String, String> params() {
        return null != this.paramsResolver ? this.paramsResolver.resolve((Object)this.uri()) : null;
    }

    public final String param(String key) {
        Map params = null;
        if (this.paramsResolver != null) {
            params = this.paramsResolver.resolve((Object)this.uri());
        }
        return null != params ? (String)params.get(key) : null;
    }

    public abstract HttpHeaders headers();

    public final HttpChannel<IN, OUT> header(String name, String value) {
        if (this.statusAndHeadersSent != 0) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.doHeader(name, value);
        return this;
    }

    protected abstract void doHeader(String var1, String var2);

    public HttpChannel<IN, OUT> addHeader(String name, String value) {
        if (this.statusAndHeadersSent != 0) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.doAddHeader(name, value);
        return this;
    }

    protected abstract void doAddHeader(String var1, String var2);

    public abstract Protocol protocol();

    public abstract String uri();

    public abstract Method method();

    void paramsResolver(HeaderResolver<String> headerResolver) {
        this.paramsResolver = headerResolver;
    }

    public abstract Status responseStatus();

    public HttpChannel<IN, OUT> responseStatus(Status status) {
        if (this.statusAndHeadersSent != 0) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.doResponseStatus(status);
        return this;
    }

    protected abstract void doResponseStatus(Status var1);

    public abstract ResponseHeaders responseHeaders();

    public final HttpChannel<IN, OUT> responseHeader(String name, String value) {
        if (this.statusAndHeadersSent != 0) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.doResponseHeader(name, value);
        return this;
    }

    protected abstract void doResponseHeader(String var1, String var2);

    public HttpChannel<IN, OUT> addResponseHeader(String name, String value) {
        if (this.statusAndHeadersSent != 0) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.doAddResponseHeader(name, value);
        return this;
    }

    protected abstract void doAddResponseHeader(String var1, String var2);

    public abstract Transfer transfer();

    public abstract HttpChannel<IN, OUT> transfer(Transfer var1);
}

