/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net;

import java.util.concurrent.atomic.AtomicBoolean;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorChannelHandler;
import reactor.rx.Promise;
import reactor.rx.Promises;

public abstract class ReactorPeer<IN, OUT, CONN extends ChannelStream<IN, OUT>> {
    private final Dispatcher defaultDispatcher;
    private final Environment defaultEnv;
    private final Codec<Buffer, IN, OUT> defaultCodec;
    private final long defaultPrefetch;
    protected final AtomicBoolean started;

    protected ReactorPeer(Environment defaultEnv, Dispatcher defaultDispatcher, Codec<Buffer, IN, OUT> codec) {
        this(defaultEnv, defaultDispatcher, codec, Long.MAX_VALUE);
    }

    protected ReactorPeer(Environment defaultEnv, Dispatcher defaultDispatcher, Codec<Buffer, IN, OUT> codec, long prefetch) {
        this.defaultEnv = defaultEnv == null && Environment.alive() ? Environment.get() : defaultEnv;
        this.defaultCodec = codec;
        this.defaultDispatcher = defaultDispatcher != null ? defaultDispatcher : SynchronousDispatcher.INSTANCE;
        this.defaultPrefetch = prefetch > 0L ? prefetch : Long.MAX_VALUE;
        this.started = new AtomicBoolean();
    }

    public final Promise<Void> start(ReactorChannelHandler<IN, OUT, CONN> handler) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Peer already started");
        }
        return this.doStart(handler);
    }

    public final Promise<Void> shutdown() {
        if (this.started.compareAndSet(true, false)) {
            return this.doShutdown();
        }
        return Promises.success();
    }

    public final Dispatcher getDefaultDispatcher() {
        return this.defaultDispatcher;
    }

    public final Codec<Buffer, IN, OUT> getDefaultCodec() {
        return this.defaultCodec;
    }

    public final Environment getDefaultEnvironment() {
        return this.defaultEnv;
    }

    public final long getDefaultPrefetchSize() {
        return this.defaultPrefetch;
    }

    protected abstract Promise<Void> doStart(ReactorChannelHandler<IN, OUT, CONN> var1);

    protected abstract Promise<Void> doShutdown();
}

