/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.tcp.ssl;

import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import reactor.fn.Supplier;
import reactor.io.net.config.SslOptions;

public class SSLEngineSupplier
implements Supplier<SSLEngine> {
    private final SSLEngine ssl;

    public SSLEngineSupplier(SslOptions sslOpts, boolean client) throws Exception {
        TrustManager[] trustManagers;
        if (null == sslOpts || null == sslOpts.keystoreFile()) {
            this.ssl = SSLContext.getDefault().createSSLEngine();
            this.ssl.setUseClientMode(client);
            return;
        }
        KeyStore ks = KeyStore.getInstance("JKS");
        FileInputStream ksin = new FileInputStream(sslOpts.keystoreFile());
        ks.load(ksin, sslOpts.keystorePasswd().toCharArray());
        SSLContext ctx = SSLContext.getInstance(sslOpts.sslProtocol());
        if (null != sslOpts.trustManagers()) {
            trustManagers = (TrustManager[])sslOpts.trustManagers().get();
        } else {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(sslOpts.trustManagerFactoryAlgorithm());
            tmf.init(ks);
            trustManagers = tmf.getTrustManagers();
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(sslOpts.keyManagerFactoryAlgorithm());
        kmf.init(ks, (null != sslOpts.keyManagerPasswd() ? sslOpts.keyManagerPasswd() : sslOpts.keystorePasswd()).toCharArray());
        KeyManager[] keyManagers = kmf.getKeyManagers();
        ctx.init(keyManagers, trustManagers, null);
        this.ssl = ctx.createSSLEngine();
        this.ssl.setUseClientMode(client);
    }

    public SSLEngine get() {
        return this.ssl;
    }
}

