/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.tcp;

import java.net.InetSocketAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.support.Assert;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.PeerStream;
import reactor.io.net.Server;
import reactor.io.net.config.ServerSocketOptions;
import reactor.io.net.config.SslOptions;

public abstract class TcpServer<IN, OUT>
extends PeerStream<IN, OUT, ChannelStream<IN, OUT>>
implements Server<IN, OUT, ChannelStream<IN, OUT>> {
    private final InetSocketAddress listenAddress;
    private final ServerSocketOptions options;
    private final SslOptions sslOptions;

    protected TcpServer(@Nonnull Environment env, @Nonnull Dispatcher dispatcher, @Nullable InetSocketAddress listenAddress, ServerSocketOptions options, SslOptions sslOptions, @Nullable Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, codec);
        this.listenAddress = listenAddress;
        Assert.notNull((Object)options, (String)"ServerSocketOptions cannot be null");
        this.options = options;
        this.sslOptions = sslOptions;
    }

    @Override
    public Server<IN, OUT, ChannelStream<IN, OUT>> pipeline(Function<ChannelStream<IN, OUT>, ? extends Publisher<? extends OUT>> serviceFunction) {
        this.doPipeline(serviceFunction);
        return this;
    }

    protected InetSocketAddress getListenAddress() {
        return this.listenAddress;
    }

    protected ServerSocketOptions getOptions() {
        return this.options;
    }

    protected SslOptions getSslOptions() {
        return this.sslOptions;
    }
}

