/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.tcp;

import java.net.InetSocketAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.Client;
import reactor.io.net.PeerStream;
import reactor.io.net.config.ClientSocketOptions;
import reactor.io.net.config.SslOptions;

public abstract class TcpClient<IN, OUT>
extends PeerStream<IN, OUT, ChannelStream<IN, OUT>>
implements Client<IN, OUT, ChannelStream<IN, OUT>> {
    private final InetSocketAddress connectAddress;
    private final ClientSocketOptions options;
    private final SslOptions sslOptions;

    protected TcpClient(@Nonnull Environment env, @Nonnull Dispatcher dispatcher, @Nullable InetSocketAddress connectAddress, @Nullable ClientSocketOptions options, @Nullable SslOptions sslOptions, @Nullable Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, codec);
        this.connectAddress = null != connectAddress ? connectAddress : new InetSocketAddress("127.0.0.1", 3000);
        this.options = options;
        this.sslOptions = sslOptions;
    }

    @Override
    public Client<IN, OUT, ChannelStream<IN, OUT>> pipeline(Function<ChannelStream<IN, OUT>, ? extends Publisher<? extends OUT>> serviceFunction) {
        this.doPipeline(serviceFunction);
        return this;
    }

    public InetSocketAddress getConnectAddress() {
        return this.connectAddress;
    }

    protected ClientSocketOptions getOptions() {
        return this.options;
    }

    protected SslOptions getSslOptions() {
        return this.sslOptions;
    }
}

