/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ChannelFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannelConfig;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.core.support.NamedDaemonThreadFactory;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.config.ServerSocketOptions;
import reactor.io.net.impl.netty.NettyChannelStream;
import reactor.io.net.impl.netty.NettyNetChannelInboundHandler;
import reactor.io.net.impl.netty.NettyServerSocketOptions;
import reactor.io.net.udp.DatagramServer;
import reactor.rx.Promise;
import reactor.rx.Promises;

public class NettyDatagramServer<IN, OUT>
extends DatagramServer<IN, OUT> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NettyServerSocketOptions nettyOptions;
    private final Bootstrap bootstrap;
    private final EventLoopGroup ioGroup;
    private volatile NioDatagramChannel channel;
    private volatile NettyChannelStream<IN, OUT> netChannel;

    public NettyDatagramServer(@Nonnull Environment env, @Nonnull Dispatcher dispatcher, @Nullable InetSocketAddress listenAddress, final @Nullable NetworkInterface multicastInterface, final @Nonnull ServerSocketOptions options, @Nullable Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, listenAddress, multicastInterface, options, codec);
        this.nettyOptions = options instanceof NettyServerSocketOptions ? (NettyServerSocketOptions)options : null;
        if (null != this.nettyOptions && null != this.nettyOptions.eventLoopGroup()) {
            this.ioGroup = this.nettyOptions.eventLoopGroup();
        } else {
            int ioThreadCount = (Integer)this.getEnvironment().getProperty("reactor.udp.ioThreadCount", Integer.class, (Object)Environment.PROCESSORS);
            this.ioGroup = new NioEventLoopGroup(ioThreadCount, (ThreadFactory)new NamedDaemonThreadFactory("reactor-udp-io"));
        }
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.ioGroup)).option(ChannelOption.SO_RCVBUF, (Object)options.rcvbuf())).option(ChannelOption.SO_SNDBUF, (Object)options.sndbuf())).option(ChannelOption.SO_REUSEADDR, (Object)options.reuseAddr())).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

            public Channel newChannel() {
                NioDatagramChannel ch = new NioDatagramChannel();
                DatagramChannelConfig config = ch.config();
                config.setReceiveBufferSize(options.rcvbuf());
                config.setSendBufferSize(options.sndbuf());
                config.setReuseAddress(options.reuseAddr());
                config.setAutoRead(false);
                if (null != multicastInterface) {
                    config.setNetworkInterface(multicastInterface);
                }
                if (null != NettyDatagramServer.this.nettyOptions && null != NettyDatagramServer.this.nettyOptions.pipelineConfigurer()) {
                    NettyDatagramServer.this.nettyOptions.pipelineConfigurer().accept((Object)ch.pipeline());
                }
                return ch;
            }
        })).handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

            public void initChannel(NioDatagramChannel ch) throws Exception {
                ch.config().setConnectTimeoutMillis(options.timeout());
                ch.config().setAutoRead(false);
                NettyDatagramServer.this.bindChannel(ch, options.prefetch());
            }
        });
        if (null != listenAddress) {
            this.bootstrap.localAddress((SocketAddress)listenAddress);
        } else {
            this.bootstrap.localAddress(NetUtil.LOCALHOST, 3000);
        }
        if (null != multicastInterface) {
            this.bootstrap.option(ChannelOption.IP_MULTICAST_IF, (Object)multicastInterface);
        }
    }

    @Override
    public Promise<Boolean> start() {
        final Promise promise = Promises.ready((Environment)this.getEnvironment(), (Dispatcher)this.getDispatcher());
        ChannelFuture future = this.bootstrap.bind();
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    NettyDatagramServer.this.log.info("BIND {}", (Object)future.channel().localAddress());
                    NettyDatagramServer.this.channel = (NioDatagramChannel)future.channel();
                    promise.onNext((Object)true);
                } else {
                    promise.onError(future.cause());
                }
            }
        });
        return promise;
    }

    @Override
    public Promise<Boolean> shutdown() {
        final Promise d = Promises.ready((Environment)this.getEnvironment(), (Dispatcher)this.getDispatcher());
        ChannelFuture future = this.channel.close();
        final GenericFutureListener listener = new GenericFutureListener(){

            public void operationComplete(Future future) throws Exception {
                if (future.isSuccess()) {
                    d.onNext((Object)true);
                    NettyDatagramServer.this.notifyShutdown();
                } else {
                    d.onError(future.cause());
                }
            }
        };
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    d.onError(future.cause());
                    return;
                }
                if (null == NettyDatagramServer.this.nettyOptions || null == NettyDatagramServer.this.nettyOptions.eventLoopGroup()) {
                    NettyDatagramServer.this.ioGroup.shutdownGracefully().addListener(listener);
                }
            }
        });
        return d;
    }

    @Override
    public Promise<Void> join(InetAddress multicastAddress, NetworkInterface iface) {
        if (null == this.channel) {
            throw new IllegalStateException("DatagramServer not running.");
        }
        Promise d = Promises.ready((Environment)this.getEnvironment(), (Dispatcher)this.getDispatcher());
        if (null == iface && null != this.getMulticastInterface()) {
            iface = this.getMulticastInterface();
        }
        ChannelFuture future = null != iface ? this.channel.joinGroup(new InetSocketAddress(multicastAddress, this.getListenAddress().getPort()), iface) : this.channel.joinGroup(multicastAddress);
        future.addListener((GenericFutureListener)new PromiseCompletingListener(d));
        return d;
    }

    @Override
    public Promise<Void> leave(InetAddress multicastAddress, NetworkInterface iface) {
        if (null == this.channel) {
            throw new IllegalStateException("DatagramServer not running.");
        }
        if (null == iface && null != this.getMulticastInterface()) {
            iface = this.getMulticastInterface();
        }
        Promise d = Promises.ready((Environment)this.getEnvironment(), (Dispatcher)this.getDispatcher());
        ChannelFuture future = null != iface ? this.channel.leaveGroup(new InetSocketAddress(multicastAddress, this.getListenAddress().getPort()), iface) : this.channel.leaveGroup(multicastAddress);
        future.addListener((GenericFutureListener)new PromiseCompletingListener(d));
        return d;
    }

    @Override
    protected NettyChannelStream<IN, OUT> bindChannel(Object _ioChannel, long prefetch) {
        NioDatagramChannel ioChannel = (NioDatagramChannel)_ioChannel;
        NettyChannelStream netChannel = new NettyChannelStream(this.getEnvironment(), this.getDefaultCodec(), prefetch == -1L ? this.getPrefetchSize() : prefetch, this, (Dispatcher)SynchronousDispatcher.INSTANCE, this.getDispatcher(), (Channel)ioChannel);
        ChannelPipeline pipeline = ioChannel.pipeline();
        if (this.log.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(this.getClass())});
        }
        pipeline.addLast(new ChannelHandler[]{new NettyNetChannelInboundHandler<IN>(netChannel.in(), netChannel){

            @Override
            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg != null && DatagramPacket.class.isAssignableFrom(msg.getClass())) {
                    super.channelRead(ctx, ((DatagramPacket)msg).content());
                } else {
                    super.channelRead(ctx, msg);
                }
            }
        }, new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                super.write(ctx, msg, promise);
            }
        }});
        return netChannel;
    }

    private static class PromiseCompletingListener
    implements ChannelFutureListener {
        private final Promise<Void> d;

        private PromiseCompletingListener(Promise<Void> d) {
            this.d = d;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                this.d.onComplete();
            } else {
                this.d.onError(future.cause());
            }
        }
    }
}

