/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.support.NamedDaemonThreadFactory;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.fn.Supplier;
import reactor.fn.tuple.Tuple2;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.Reconnect;
import reactor.io.net.config.ClientSocketOptions;
import reactor.io.net.config.SslOptions;
import reactor.io.net.impl.netty.NettyChannelStream;
import reactor.io.net.impl.netty.NettyClientSocketOptions;
import reactor.io.net.impl.netty.NettyEventLoopDispatcher;
import reactor.io.net.impl.netty.NettyNetChannelInboundHandler;
import reactor.io.net.tcp.TcpClient;
import reactor.io.net.tcp.ssl.SSLEngineSupplier;
import reactor.rx.Promise;
import reactor.rx.Promises;
import reactor.rx.Stream;

public class NettyTcpClient<IN, OUT>
extends TcpClient<IN, OUT> {
    private final Logger log = LoggerFactory.getLogger(NettyTcpClient.class);
    private final NettyClientSocketOptions nettyOptions;
    private final Bootstrap bootstrap;
    private final EventLoopGroup ioGroup;
    private final Supplier<ChannelFuture> connectionSupplier;
    private volatile InetSocketAddress connectAddress;
    private volatile boolean closing;

    public NettyTcpClient(Environment env, Dispatcher dispatcher, InetSocketAddress connectAddress, final ClientSocketOptions options, final SslOptions sslOptions, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, connectAddress, options, sslOptions, codec);
        this.connectAddress = connectAddress;
        this.nettyOptions = options instanceof NettyClientSocketOptions ? (NettyClientSocketOptions)options : null;
        if (null != this.nettyOptions && null != this.nettyOptions.eventLoopGroup()) {
            this.ioGroup = this.nettyOptions.eventLoopGroup();
        } else {
            int ioThreadCount = env != null ? (Integer)env.getProperty("reactor.tcp.ioThreadCount", Integer.class, (Object)Environment.PROCESSORS) : Environment.PROCESSORS;
            this.ioGroup = new NioEventLoopGroup(ioThreadCount, (ThreadFactory)new NamedDaemonThreadFactory("reactor-tcp-io"));
        }
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.ioGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_RCVBUF, (Object)options.rcvbuf())).option(ChannelOption.SO_SNDBUF, (Object)options.sndbuf())).option(ChannelOption.SO_KEEPALIVE, (Object)options.keepAlive())).option(ChannelOption.SO_LINGER, (Object)options.linger())).option(ChannelOption.TCP_NODELAY, (Object)options.tcpNoDelay())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.AUTO_READ, (Object)(sslOptions != null ? 1 : 0))).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.config().setConnectTimeoutMillis(options.timeout());
                if (null != sslOptions) {
                    SSLEngine ssl = new SSLEngineSupplier(sslOptions, true).get();
                    if (NettyTcpClient.this.log.isDebugEnabled()) {
                        NettyTcpClient.this.log.debug("SSL enabled using keystore {}", (Object)(null != sslOptions.keystoreFile() ? sslOptions.keystoreFile() : "<DEFAULT>"));
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(ssl)});
                } else {
                    ch.config().setAutoRead(false);
                }
                if (null != NettyTcpClient.this.nettyOptions && null != NettyTcpClient.this.nettyOptions.pipelineConfigurer()) {
                    NettyTcpClient.this.nettyOptions.pipelineConfigurer().accept((Object)ch.pipeline());
                }
                NettyTcpClient.this.bindChannel(ch, options.prefetch());
            }
        });
        this.connectionSupplier = new Supplier<ChannelFuture>(){

            public ChannelFuture get() {
                if (!NettyTcpClient.this.closing) {
                    return NettyTcpClient.this.bootstrap.connect((SocketAddress)NettyTcpClient.this.getConnectAddress());
                }
                return null;
            }
        };
    }

    @Override
    public Promise<Boolean> open() {
        Promise connection = this.map(new Function<ChannelStream<IN, OUT>, Boolean>(){

            public Boolean apply(ChannelStream<IN, OUT> channelStream) {
                return true;
            }
        }).next();
        this.openChannel(new ConnectingChannelListener());
        return connection;
    }

    @Override
    public Stream<Boolean> open(Reconnect reconnect) {
        this.openChannel(new ReconnectingChannelListener(this.connectAddress, reconnect));
        return this.map(new Function<ChannelStream<IN, OUT>, Boolean>(){

            public Boolean apply(ChannelStream<IN, OUT> channelStream) {
                return true;
            }
        });
    }

    @Override
    public Promise<Boolean> close() {
        if (this.closing) {
            return Promises.success((Object)true);
        }
        final Promise promise = Promises.ready((Environment)this.getEnvironment(), (Dispatcher)this.getDispatcher());
        this.closing = true;
        this.ioGroup.shutdownGracefully().addListener((GenericFutureListener)new FutureListener<Object>(){

            public void operationComplete(Future<Object> future) throws Exception {
                if (future.isDone() && future.isSuccess()) {
                    promise.onNext((Object)true);
                } else {
                    promise.onError(future.cause());
                }
            }
        });
        return promise;
    }

    @Override
    protected NettyChannelStream<IN, OUT> bindChannel(Object nativeChannel, long prefetch) {
        SocketChannel ch = (SocketChannel)nativeChannel;
        int backlog = (Integer)this.getEnvironment().getProperty("reactor.tcp.connectionReactorBacklog", Integer.class, (Object)128);
        NettyChannelStream netChannel = new NettyChannelStream(this.getEnvironment(), this.getDefaultCodec(), prefetch == -1L ? this.getPrefetchSize() : prefetch, this, (Dispatcher)new NettyEventLoopDispatcher(ch.eventLoop(), backlog), this.getDispatcher(), (Channel)ch);
        ChannelPipeline pipeline = ch.pipeline();
        if (this.log.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(this.getClass())});
        }
        pipeline.addLast(new ChannelHandler[]{new NettyNetChannelInboundHandler(netChannel.in(), netChannel)});
        return netChannel;
    }

    private void openChannel(ChannelFutureListener listener) {
        ChannelFuture channel = (ChannelFuture)this.connectionSupplier.get();
        if (null != channel && null != listener) {
            channel.addListener((GenericFutureListener)listener);
        }
    }

    private class ReconnectingChannelListener
    implements ChannelFutureListener {
        private final AtomicInteger attempts = new AtomicInteger(0);
        private final Reconnect reconnect;
        private volatile InetSocketAddress connectAddress;

        private ReconnectingChannelListener(InetSocketAddress connectAddress, Reconnect reconnect) {
            this.connectAddress = connectAddress;
            this.reconnect = reconnect;
        }

        public void operationComplete(final ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                int attempt = this.attempts.incrementAndGet();
                Tuple2<InetSocketAddress, Long> tup = this.reconnect.reconnect(this.connectAddress, attempt);
                if (null == tup) {
                    if (NettyTcpClient.this.log.isErrorEnabled()) {
                        NettyTcpClient.this.log.error("Reconnection to {} failed after {} attempts. Giving up.", (Object)this.connectAddress, (Object)(attempt - 1));
                    }
                    future.channel().eventLoop().submit(new Runnable(){

                        @Override
                        public void run() {
                            NettyTcpClient.this.notifyError(future.cause());
                        }
                    });
                    return;
                }
                this.attemptReconnect(tup);
            } else {
                if (NettyTcpClient.this.log.isInfoEnabled()) {
                    NettyTcpClient.this.log.info("CONNECTED: " + future.channel());
                }
                final Channel ioCh = future.channel();
                ioCh.pipeline().addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        Tuple2<InetSocketAddress, Long> tup;
                        if (NettyTcpClient.this.log.isInfoEnabled()) {
                            NettyTcpClient.this.log.info("CLOSED: " + ioCh);
                        }
                        if (null == (tup = ReconnectingChannelListener.this.reconnect.reconnect(ReconnectingChannelListener.this.connectAddress, ReconnectingChannelListener.this.attempts.incrementAndGet()))) {
                            return;
                        }
                        if (!NettyTcpClient.this.closing) {
                            ReconnectingChannelListener.this.attemptReconnect((Tuple2<InetSocketAddress, Long>)tup);
                        }
                        super.channelInactive(ctx);
                    }
                }});
            }
        }

        private void attemptReconnect(Tuple2<InetSocketAddress, Long> tup) {
            this.connectAddress = (InetSocketAddress)tup.getT1();
            NettyTcpClient.this.bootstrap.remoteAddress((SocketAddress)this.connectAddress);
            long delay = (Long)tup.getT2();
            if (NettyTcpClient.this.log.isInfoEnabled()) {
                NettyTcpClient.this.log.info("Failed to connect to {}. Attempting reconnect in {}ms.", (Object)this.connectAddress, (Object)delay);
            }
            NettyTcpClient.this.getEnvironment().getTimer().submit((Consumer)new Consumer<Long>(){

                public void accept(Long now) {
                    NettyTcpClient.this.openChannel(ReconnectingChannelListener.this);
                }
            }, delay, TimeUnit.MILLISECONDS).cancelAfterUse();
        }
    }

    private class ConnectingChannelListener
    implements ChannelFutureListener {
        private ConnectingChannelListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                if (NettyTcpClient.this.log.isErrorEnabled()) {
                    NettyTcpClient.this.log.error(future.cause().getMessage(), future.cause());
                }
                NettyTcpClient.this.notifyError(future.cause());
                return;
            }
        }
    }
}

