/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.http;

import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import reactor.io.net.http.HttpChannel;
import reactor.io.net.impl.netty.NettyChannelStream;
import reactor.io.net.impl.netty.NettyNetChannelInboundHandler;
import reactor.io.net.impl.netty.http.NettyHttpServer;

public class NettyHttpServerHandler<IN, OUT>
extends NettyNetChannelInboundHandler<IN> {
    private final NettyHttpServer<IN, OUT> server;
    private final NettyChannelStream<IN, OUT> tcpStream;
    private HttpChannel<IN, OUT> request;

    public NettyHttpServerHandler(NettyChannelStream<IN, OUT> tcpStream, NettyHttpServer<IN, OUT> server) {
        super(tcpStream.in(), tcpStream);
        this.server = server;
        this.tcpStream = tcpStream;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        if (ctx.channel().isActive()) {
            ctx.read();
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Class<?> messageClass = msg.getClass();
        if (this.request == null && HttpRequest.class.isAssignableFrom(messageClass)) {
            this.request = this.server.createServerRequest(this.tcpStream, (HttpRequest)msg);
        } else if (HttpContent.class.isAssignableFrom(messageClass)) {
            super.channelRead(ctx, ((ByteBufHolder)msg).content());
        }
    }
}

