/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.http;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import reactor.io.net.http.model.ResponseHeaders;

public class NettyHttpResponseHeaders
implements ResponseHeaders {
    private final HttpResponse nettyResponse;
    private final HttpHeaders nettyHeaders;

    public NettyHttpResponseHeaders(HttpResponse nettyResponse) {
        this.nettyResponse = nettyResponse;
        this.nettyHeaders = nettyResponse.headers();
    }

    @Override
    public boolean contains(String name) {
        return this.nettyHeaders.contains(name);
    }

    @Override
    public boolean contains(String name, String value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name, value, ignoreCaseValue);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return this.nettyHeaders.entries();
    }

    @Override
    public String get(String name) {
        return this.nettyHeaders.get(name);
    }

    @Override
    public List<String> getAll(String name) {
        return this.nettyHeaders.getAll(name);
    }

    @Override
    public Date getDate() throws ParseException {
        return HttpHeaders.getDate((HttpMessage)this.nettyResponse);
    }

    @Override
    public Date getDateHeader(String name) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyResponse, (String)name);
    }

    @Override
    public String getHost() {
        return HttpHeaders.getHost((HttpMessage)this.nettyResponse);
    }

    @Override
    public boolean isEmpty() {
        return this.nettyHeaders.isEmpty();
    }

    @Override
    public Set<String> names() {
        return this.nettyHeaders.names();
    }

    @Override
    public long getContentLength() {
        return 0L;
    }

    @Override
    public ResponseHeaders add(String name, String value) {
        this.nettyHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public ResponseHeaders add(String name, Iterable<String> values) {
        this.nettyHeaders.add(name, values);
        return this;
    }

    @Override
    public ResponseHeaders addDateHeader(String name, Date value) {
        HttpHeaders.addDateHeader((HttpMessage)this.nettyResponse, (String)name, (Date)value);
        return this;
    }

    @Override
    public ResponseHeaders clear() {
        this.nettyHeaders.clear();
        return this;
    }

    @Override
    public ResponseHeaders remove(String name) {
        this.nettyHeaders.remove(name);
        return this;
    }

    @Override
    public ResponseHeaders removeTransferEncodingChunked() {
        HttpHeaders.removeTransferEncodingChunked((HttpMessage)this.nettyResponse);
        return this;
    }

    @Override
    public ResponseHeaders set(String name, String value) {
        this.nettyHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public ResponseHeaders set(String name, Iterable<String> values) {
        this.nettyHeaders.set(name, values);
        return this;
    }

    @Override
    public ResponseHeaders contentLength(long length) {
        HttpHeaders.setContentLength((HttpMessage)this.nettyResponse, (long)length);
        return this;
    }

    @Override
    public ResponseHeaders date(Date value) {
        HttpHeaders.setDate((HttpMessage)this.nettyResponse, (Date)value);
        return this;
    }

    @Override
    public ResponseHeaders dateHeader(String name, Date value) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyResponse, (String)name, (Date)value);
        return this;
    }

    @Override
    public ResponseHeaders dateHeader(String name, Iterable<Date> values) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyResponse, (String)name, values);
        return this;
    }

    @Override
    public ResponseHeaders host(String value) {
        HttpHeaders.setHost((HttpMessage)this.nettyResponse, (String)value);
        return this;
    }

    @Override
    public ResponseHeaders keepAlive(boolean keepAlive) {
        HttpHeaders.setKeepAlive((HttpMessage)this.nettyResponse, (boolean)keepAlive);
        return this;
    }

    @Override
    public ResponseHeaders transferEncodingChunked() {
        HttpHeaders.setTransferEncodingChunked((HttpMessage)this.nettyResponse);
        return this;
    }
}

