/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.http;

import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import reactor.io.net.impl.netty.NettyChannelStream;
import reactor.io.net.impl.netty.NettyNetChannelInboundHandler;
import reactor.io.net.impl.netty.http.NettyHttpChannel;
import reactor.io.net.impl.netty.http.NettyHttpClient;

public class NettyHttpClientHandler<IN, OUT>
extends NettyNetChannelInboundHandler<IN> {
    private static final AttributeKey<NettyHttpChannel> KEY = AttributeKey.valueOf((String)"httpChannel");
    private final NettyChannelStream<IN, OUT> tcpStream;
    private final NettyHttpClient<IN, OUT> client;

    public NettyHttpClientHandler(NettyChannelStream<IN, OUT> tcpStream, NettyHttpClient<IN, OUT> client) {
        super(tcpStream.in(), tcpStream);
        this.client = client;
        this.tcpStream = tcpStream;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        NettyHttpChannel<IN, OUT> inoutHttpChannel = this.client.createClientRequest(this.tcpStream, (HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/"));
        ctx.attr(KEY).set(inoutHttpChannel);
        this.tcpStream.subscribe(inoutHttpChannel.in());
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Class<?> messageClass = msg.getClass();
        if (HttpResponse.class.isAssignableFrom(messageClass)) {
            NettyHttpChannel httpChannel = (NettyHttpChannel)ctx.attr(KEY).getAndRemove();
            if (httpChannel != null) {
                httpChannel.setNettyResponse((HttpResponse)msg);
            }
        } else if (HttpContent.class.isAssignableFrom(messageClass)) {
            super.channelRead(ctx, ((ByteBufHolder)msg).content());
        }
    }
}

