/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.core.support.Assert;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.Channel;
import reactor.io.net.ChannelStream;
import reactor.io.net.PeerStream;
import reactor.io.net.http.HttpChannel;
import reactor.io.net.http.model.HttpHeaders;
import reactor.io.net.http.model.Method;
import reactor.io.net.http.model.Protocol;
import reactor.io.net.http.model.ResponseHeaders;
import reactor.io.net.http.model.Status;
import reactor.io.net.http.model.Transfer;
import reactor.io.net.impl.netty.NettyChannelStream;
import reactor.io.net.impl.netty.http.NettyHttpHeaders;
import reactor.io.net.impl.netty.http.NettyHttpResponseHeaders;

public class NettyHttpChannel<IN, OUT>
extends HttpChannel<IN, OUT> {
    private final NettyChannelStream<IN, OUT> tcpStream;
    private final HttpRequest nettyRequest;
    private final NettyHttpHeaders headers;
    private HttpResponse nettyResponse;
    private NettyHttpResponseHeaders responseHeaders;

    public NettyHttpChannel(NettyChannelStream<IN, OUT> tcpStream, PeerStream<IN, OUT, ChannelStream<IN, OUT>> server, HttpRequest request, Codec<Buffer, IN, OUT> codec) {
        super(tcpStream.getEnvironment(), codec, tcpStream.getCapacity(), server, (Dispatcher)SynchronousDispatcher.INSTANCE, (Dispatcher)SynchronousDispatcher.INSTANCE);
        this.tcpStream = tcpStream;
        this.nettyRequest = request;
        this.nettyResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.headers = new NettyHttpHeaders(request);
        this.responseHeaders = new NettyHttpResponseHeaders(this.nettyResponse);
        this.responseHeader("Transfer-Encoding", "chunked");
    }

    @Override
    public Protocol protocol() {
        HttpVersion version = this.nettyRequest.getProtocolVersion();
        if (version.equals((Object)HttpVersion.HTTP_1_0)) {
            return Protocol.HTTP_1_0;
        }
        if (version.equals((Object)HttpVersion.HTTP_1_1)) {
            return Protocol.HTTP_2_0;
        }
        throw new IllegalStateException(version.protocolName() + " not supported");
    }

    @Override
    protected void doHeader(String name, String value) {
        this.headers.set(name, value);
    }

    @Override
    protected void doAddHeader(String name, String value) {
        this.headers.add(name, value);
    }

    @Override
    public String uri() {
        return this.nettyRequest.getUri();
    }

    @Override
    public Method method() {
        return new Method(this.nettyRequest.getMethod().name());
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    public HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    @Override
    public Status responseStatus() {
        return Status.valueOf(this.nettyResponse.getStatus().code());
    }

    @Override
    public void doResponseStatus(Status status) {
        this.nettyResponse.setStatus(HttpResponseStatus.valueOf((int)status.getCode()));
    }

    @Override
    public Transfer transfer() {
        if ("chunked".equals(this.headers.get("Transfer-Encoding"))) {
            Assert.isTrue((boolean)Protocol.HTTP_1_1.equals((Object)this.protocol()));
            return Transfer.CHUNKED;
        }
        if (this.headers.get("Transfer-Encoding") == null) {
            return Transfer.NON_CHUNKED;
        }
        throw new IllegalStateException("Can't determine a valide transfer based on headers and protocol");
    }

    @Override
    public HttpChannel<IN, OUT> transfer(Transfer transfer) {
        switch (transfer) {
            case EVENT_STREAM: {
                throw new IllegalStateException("Transfer " + (Object)((Object)Transfer.EVENT_STREAM) + " is not supported yet");
            }
            case CHUNKED: {
                Assert.isTrue((boolean)Protocol.HTTP_1_1.equals((Object)this.protocol()));
                this.responseHeader("Transfer-Encoding", "chunked");
                break;
            }
            case NON_CHUNKED: {
                this.responseHeaders().remove("Transfer-Encoding");
            }
        }
        return this;
    }

    @Override
    public ResponseHeaders responseHeaders() {
        return this.responseHeaders;
    }

    @Override
    protected void doResponseHeader(String name, String value) {
        this.responseHeaders.set(name, value);
    }

    @Override
    protected void doAddResponseHeader(String name, String value) {
        this.responseHeaders.add(name, value);
    }

    public HttpResponse getNettyResponse() {
        return this.nettyResponse;
    }

    public Channel delegate() {
        return this.tcpStream.delegate();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.tcpStream.remoteAddress();
    }

    @Override
    public Channel.ConsumerSpec on() {
        return this.tcpStream.on();
    }

    void setNettyResponse(HttpResponse nettyResponse) {
        this.nettyResponse = nettyResponse;
    }

    @Override
    protected void write(ByteBuffer data, Subscriber<?> onComplete, boolean flush) {
        this.write(new DefaultHttpContent(Unpooled.wrappedBuffer((ByteBuffer)data)), onComplete, flush);
    }

    @Override
    protected void write(Object data, Subscriber<?> onComplete, boolean flush) {
        boolean willFlush = flush;
        if (HEADERS_SENT.compareAndSet(this, 0, 1)) {
            this.tcpStream.write(this.nettyResponse, onComplete, false);
            willFlush = true;
        }
        this.tcpStream.write(data, onComplete, willFlush);
    }

    @Override
    protected void flush() {
        this.tcpStream.flush();
    }

    NettyChannelStream<IN, OUT> tcpStream() {
        return this.tcpStream;
    }
}

