/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty;

import io.netty.channel.EventLoop;
import java.util.concurrent.TimeUnit;
import reactor.core.dispatch.AbstractLifecycleDispatcher;
import reactor.core.dispatch.MultiThreadDispatcher;

public class NettyEventLoopDispatcher
extends MultiThreadDispatcher {
    private final EventLoop eventLoop;

    public NettyEventLoopDispatcher(EventLoop eventLoop, int backlog) {
        super(1, backlog);
        this.eventLoop = eventLoop;
    }

    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        this.shutdown();
        try {
            return this.eventLoop.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void shutdown() {
        this.eventLoop.shutdownGracefully();
        super.shutdown();
    }

    public void forceShutdown() {
        this.eventLoop.shutdownGracefully();
        super.forceShutdown();
    }

    protected void execute(AbstractLifecycleDispatcher.Task task) {
        this.eventLoop.execute((Runnable)task);
    }

    public void execute(Runnable command) {
        this.eventLoop.execute(command);
    }

    public long remainingSlots() {
        return Long.MAX_VALUE;
    }

    public long backlogSize() {
        return Long.MAX_VALUE;
    }

    public boolean supportsOrdering() {
        return true;
    }
}

