/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.http;

import java.util.Iterator;
import org.reactivestreams.Publisher;
import reactor.Environment;
import reactor.bus.registry.Registration;
import reactor.bus.registry.Registries;
import reactor.bus.registry.Registry;
import reactor.bus.selector.HeaderResolver;
import reactor.bus.selector.Selector;
import reactor.bus.selector.Selectors;
import reactor.core.Dispatcher;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.NetSelectors;
import reactor.io.net.PeerStream;
import reactor.io.net.Server;
import reactor.io.net.http.HttpChannel;

public abstract class HttpServer<IN, OUT>
extends PeerStream<IN, OUT, HttpChannel<IN, OUT>>
implements Server<IN, OUT, HttpChannel<IN, OUT>> {
    protected final Registry<Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>>> routedWriters = Registries.create();

    protected HttpServer(Environment env, Dispatcher dispatcher, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, codec);
    }

    public HttpServer<IN, OUT> route(Selector condition, Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> serviceFunction) {
        this.routedWriters.register(condition, serviceFunction);
        return this;
    }

    @Override
    public Server<IN, OUT, HttpChannel<IN, OUT>> pipeline(Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> serviceFunction) {
        this.route(Selectors.matchAll(), serviceFunction);
        return this;
    }

    public final HttpServer<IN, OUT> get(String path, Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> handler) {
        this.route(NetSelectors.get(path), handler);
        return this;
    }

    public final HttpServer<IN, OUT> post(String path, Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> handler) {
        this.route(NetSelectors.post(path), handler);
        return this;
    }

    public final HttpServer<IN, OUT> put(String path, Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> handler) {
        this.route(NetSelectors.put(path), handler);
        return this;
    }

    public final HttpServer<IN, OUT> delete(String path, Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> handler) {
        this.route(NetSelectors.delete(path), handler);
        return this;
    }

    @Override
    protected Iterable<Publisher<? extends OUT>> routeChannel(final HttpChannel<IN, OUT> ch) {
        return new Iterable<Publisher<? extends OUT>>(){

            @Override
            public Iterator<Publisher<? extends OUT>> iterator() {
                final Iterator iterator = HttpServer.this.routedWriters.select((Object)ch).iterator();
                return new Iterator<Publisher<? extends OUT>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public Publisher<? extends OUT> next() {
                        Registration next = (Registration)iterator.next();
                        if (next != null) {
                            ch.paramsResolver((HeaderResolver<String>)next.getSelector().getHeaderResolver());
                            return (Publisher)((Function)next.getObject()).apply((Object)ch);
                        }
                        return null;
                    }
                };
            }
        };
    }
}

