/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.http;

import org.reactivestreams.Publisher;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.Client;
import reactor.io.net.PeerStream;
import reactor.io.net.http.HttpChannel;
import reactor.io.net.http.model.Method;
import reactor.rx.Promise;

public abstract class HttpClient<IN, OUT>
extends PeerStream<IN, OUT, HttpChannel<IN, OUT>>
implements Client<IN, OUT, HttpChannel<IN, OUT>> {
    protected HttpClient(Environment env, Dispatcher dispatcher, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, codec);
    }

    @Override
    public Client<IN, OUT, HttpChannel<IN, OUT>> pipeline(Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> serviceFunction) {
        this.doPipeline(serviceFunction);
        return this;
    }

    public final Promise<? extends HttpChannel<IN, OUT>> get(String url, Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> handler) {
        return this.request(Method.GET, url, handler);
    }

    public final Promise<? extends HttpChannel<IN, OUT>> post(String url, Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> handler) {
        return this.request(Method.POST, url, handler);
    }

    public final Promise<? extends HttpChannel<IN, OUT>> put(String url, Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> handler) {
        return this.request(Method.PUT, url, handler);
    }

    public final Promise<? extends HttpChannel<IN, OUT>> delete(String url, Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> handler) {
        return this.request(Method.DELETE, url, handler);
    }

    public final Promise<? extends HttpChannel<IN, OUT>> delete(String url) {
        return this.request(Method.DELETE, url, null);
    }

    public abstract Promise<? extends HttpChannel<IN, OUT>> request(Method var1, String var2, Function<HttpChannel<IN, OUT>, ? extends Publisher<? extends OUT>> var3);
}

