/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net;

import reactor.Environment;
import reactor.core.support.Assert;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.net.ChannelStream;
import reactor.io.net.Spec;
import reactor.io.net.http.HttpClient;
import reactor.io.net.http.HttpServer;
import reactor.io.net.impl.netty.http.NettyHttpClient;
import reactor.io.net.impl.netty.http.NettyHttpServer;
import reactor.io.net.impl.netty.tcp.NettyTcpClient;
import reactor.io.net.impl.netty.tcp.NettyTcpServer;
import reactor.io.net.impl.netty.udp.NettyDatagramServer;
import reactor.io.net.impl.zmq.tcp.ZeroMQTcpClient;
import reactor.io.net.impl.zmq.tcp.ZeroMQTcpServer;
import reactor.io.net.tcp.TcpClient;
import reactor.io.net.tcp.TcpServer;
import reactor.io.net.udp.DatagramServer;
import reactor.rx.Streams;

public class NetStreams
extends Streams {
    public static final int DEFAULT_PORT = 12012;
    public static final String DEFAULT_BIND_ADDRESS = "127.0.0.1";
    public static final Class<? extends TcpServer> DEFAULT_TCP_SERVER_TYPE;
    public static final Class<? extends TcpClient> DEFAULT_TCP_CLIENT_TYPE;
    public static final Class<? extends HttpServer> DEFAULT_HTTP_SERVER_TYPE;
    public static final Class<? extends HttpClient> DEFAULT_HTTP_CLIENT_TYPE;
    public static final Class<? extends DatagramServer> DEFAULT_UDP_SERVER_TYPE;

    private NetStreams() {
    }

    public static TcpServer<Buffer, Buffer> tcpServer() {
        return NetStreams.tcpServer(DEFAULT_BIND_ADDRESS);
    }

    public static TcpServer<Buffer, Buffer> tcpServer(int port) {
        return NetStreams.tcpServer(DEFAULT_BIND_ADDRESS, port);
    }

    public static TcpServer<Buffer, Buffer> tcpServer(String bindAddress) {
        return NetStreams.tcpServer(bindAddress, 12012);
    }

    public static TcpServer<Buffer, Buffer> tcpServer(final String bindAddress, final int port) {
        return NetStreams.tcpServer(new Function<Spec.TcpServer<Buffer, Buffer>, Spec.TcpServer<Buffer, Buffer>>(){

            public Spec.TcpServer<Buffer, Buffer> apply(Spec.TcpServer<Buffer, Buffer> serverSpec) {
                if (Environment.alive()) {
                    serverSpec.env(Environment.get());
                }
                return (Spec.TcpServer)((Object)serverSpec.listen(bindAddress, port));
            }
        });
    }

    public static <IN, OUT> TcpServer<IN, OUT> tcpServer(Function<? super Spec.TcpServer<IN, OUT>, ? extends Spec.TcpServer<IN, OUT>> configuringFunction) {
        return NetStreams.tcpServer(DEFAULT_TCP_SERVER_TYPE, configuringFunction);
    }

    public static <IN, OUT> TcpServer<IN, OUT> tcpServer(Class<? extends TcpServer> serverFactory, Function<? super Spec.TcpServer<IN, OUT>, ? extends Spec.TcpServer<IN, OUT>> configuringFunction) {
        return (TcpServer)((Spec.TcpServer)((Object)configuringFunction.apply(new Spec.TcpServer(serverFactory)))).get();
    }

    public static TcpClient<Buffer, Buffer> tcpClient() {
        return NetStreams.tcpClient(DEFAULT_BIND_ADDRESS);
    }

    public static TcpClient<Buffer, Buffer> tcpClient(String bindAddress) {
        return NetStreams.tcpClient(bindAddress, 12012);
    }

    public static TcpClient<Buffer, Buffer> tcpClient(int port) {
        return NetStreams.tcpClient(DEFAULT_BIND_ADDRESS, port);
    }

    public static TcpClient<Buffer, Buffer> tcpClient(final String bindAddress, final int port) {
        return NetStreams.tcpClient(new Function<Spec.TcpClient<Buffer, Buffer>, Spec.TcpClient<Buffer, Buffer>>(){

            public Spec.TcpClient<Buffer, Buffer> apply(Spec.TcpClient<Buffer, Buffer> clientSpec) {
                if (Environment.alive()) {
                    clientSpec.env(Environment.get());
                }
                return clientSpec.connect(bindAddress, port);
            }
        });
    }

    public static <IN, OUT> TcpClient<IN, OUT> tcpClient(Function<? super Spec.TcpClient<IN, OUT>, ? extends Spec.TcpClient<IN, OUT>> configuringFunction) {
        return NetStreams.tcpClient(DEFAULT_TCP_CLIENT_TYPE, configuringFunction);
    }

    public static <IN, OUT> TcpClient<IN, OUT> tcpClient(Class<? extends TcpClient> clientFactory, Function<? super Spec.TcpClient<IN, OUT>, ? extends Spec.TcpClient<IN, OUT>> configuringFunction) {
        return (TcpClient)((Spec.TcpClient)((Object)configuringFunction.apply(new Spec.TcpClient(clientFactory)))).get();
    }

    public static HttpServer<Buffer, Buffer> httpServer() {
        return NetStreams.httpServer(DEFAULT_BIND_ADDRESS);
    }

    public static <IN, OUT> HttpServer<IN, OUT> httpServer(String bindAddress) {
        return NetStreams.httpServer(bindAddress, 12012);
    }

    public static <IN, OUT> HttpServer<IN, OUT> httpServer(int port) {
        return NetStreams.httpServer(DEFAULT_BIND_ADDRESS, port);
    }

    public static <IN, OUT> HttpServer<IN, OUT> httpServer(final String bindAddress, final int port) {
        return NetStreams.httpServer(new Function<Spec.HttpServer<IN, OUT>, Spec.HttpServer<IN, OUT>>(){

            public Spec.HttpServer<IN, OUT> apply(Spec.HttpServer<IN, OUT> serverSpec) {
                if (Environment.alive()) {
                    serverSpec.env(Environment.get());
                }
                return (Spec.HttpServer)((Object)serverSpec.listen(bindAddress, port));
            }
        });
    }

    public static <IN, OUT> HttpServer<IN, OUT> httpServer(Function<? super Spec.HttpServer<IN, OUT>, ? extends Spec.HttpServer<IN, OUT>> configuringFunction) {
        return NetStreams.httpServer(DEFAULT_HTTP_SERVER_TYPE, configuringFunction);
    }

    public static <IN, OUT> HttpServer<IN, OUT> httpServer(Class<? extends HttpServer> serverFactory, Function<? super Spec.HttpServer<IN, OUT>, ? extends Spec.HttpServer<IN, OUT>> configuringFunction) {
        return (HttpServer)((Spec.HttpServer)((Object)configuringFunction.apply(new Spec.HttpServer(serverFactory)))).get();
    }

    public static HttpClient<Buffer, Buffer> httpClient() {
        return NetStreams.httpClient(new Function<Spec.HttpClient<Buffer, Buffer>, Spec.HttpClient<Buffer, Buffer>>(){

            public Spec.HttpClient<Buffer, Buffer> apply(Spec.HttpClient<Buffer, Buffer> clientSpec) {
                if (Environment.alive()) {
                    clientSpec.env(Environment.get());
                }
                return clientSpec;
            }
        });
    }

    public static <IN, OUT> HttpClient<IN, OUT> httpClient(Function<? super Spec.HttpClient<IN, OUT>, ? extends Spec.HttpClient<IN, OUT>> configuringFunction) {
        return NetStreams.httpClient(DEFAULT_HTTP_CLIENT_TYPE, configuringFunction);
    }

    public static <IN, OUT> HttpClient<IN, OUT> httpClient(Class<? extends HttpClient> clientFactory, Function<? super Spec.HttpClient<IN, OUT>, ? extends Spec.HttpClient<IN, OUT>> configuringFunction) {
        return (HttpClient)((Spec.HttpClient)((Object)configuringFunction.apply(new Spec.HttpClient(clientFactory)))).get();
    }

    public static DatagramServer<Buffer, Buffer> udpServer() {
        return NetStreams.udpServer(DEFAULT_BIND_ADDRESS);
    }

    public static DatagramServer<Buffer, Buffer> udpServer(String bindAddress) {
        return NetStreams.udpServer(bindAddress, 12012);
    }

    public static DatagramServer<Buffer, Buffer> udpServer(int port) {
        return NetStreams.udpServer(DEFAULT_BIND_ADDRESS, port);
    }

    public static DatagramServer<Buffer, Buffer> udpServer(final String bindAddress, final int port) {
        return NetStreams.udpServer(new Function<Spec.DatagramServer<Buffer, Buffer>, Spec.DatagramServer<Buffer, Buffer>>(){

            public Spec.DatagramServer<Buffer, Buffer> apply(Spec.DatagramServer<Buffer, Buffer> serverSpec) {
                if (Environment.alive()) {
                    serverSpec.env(Environment.get());
                }
                return (Spec.DatagramServer)((Object)serverSpec.listen(bindAddress, port));
            }
        });
    }

    public static <IN, OUT> DatagramServer<IN, OUT> udpServer(Function<? super Spec.DatagramServer<IN, OUT>, ? extends Spec.DatagramServer<IN, OUT>> configuringFunction) {
        return NetStreams.udpServer(DEFAULT_UDP_SERVER_TYPE, configuringFunction);
    }

    public static <IN, OUT> DatagramServer<IN, OUT> udpServer(Class<? extends DatagramServer> serverFactory, Function<? super Spec.DatagramServer<IN, OUT>, ? extends Spec.DatagramServer<IN, OUT>> configuringFunction) {
        return (DatagramServer)((Spec.DatagramServer)((Object)configuringFunction.apply(new Spec.DatagramServer(serverFactory)))).get();
    }

    public static <E, IN, OUT> E delegate(ChannelStream<IN, OUT> channelStream) {
        return (E)NetStreams.delegate(channelStream, Object.class);
    }

    public static <E, IN, OUT> E delegate(ChannelStream<IN, OUT> channelStream, Class<E> clazz) {
        Assert.isTrue((boolean)clazz.isAssignableFrom(channelStream.delegate().getClass()), (String)("Underlying channel is not of the given type: " + clazz.getName()));
        return (E)channelStream.delegate();
    }

    public static Spec.IncrementalBackoffReconnect backoffReconnect() {
        return new Spec.IncrementalBackoffReconnect();
    }

    static {
        boolean hasNetty = false;
        try {
            Class.forName("io.netty.channel.Channel");
            hasNetty = true;
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (hasNetty) {
            DEFAULT_TCP_SERVER_TYPE = NettyTcpServer.class;
            DEFAULT_TCP_CLIENT_TYPE = NettyTcpClient.class;
            DEFAULT_UDP_SERVER_TYPE = NettyDatagramServer.class;
            DEFAULT_HTTP_SERVER_TYPE = NettyHttpServer.class;
            DEFAULT_HTTP_CLIENT_TYPE = NettyHttpClient.class;
        } else {
            boolean hasZMQ = false;
            DEFAULT_UDP_SERVER_TYPE = null;
            DEFAULT_HTTP_SERVER_TYPE = null;
            DEFAULT_HTTP_CLIENT_TYPE = null;
            try {
                Class.forName("org.zeromq.ZMQ");
                hasZMQ = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (hasZMQ) {
                DEFAULT_TCP_SERVER_TYPE = ZeroMQTcpServer.class;
                DEFAULT_TCP_CLIENT_TYPE = ZeroMQTcpClient.class;
            } else {
                DEFAULT_TCP_SERVER_TYPE = null;
                DEFAULT_TCP_CLIENT_TYPE = null;
            }
        }
    }
}

