/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.buffer;

import java.nio.ByteBuffer;
import java.util.List;
import reactor.alloc.Allocator;
import reactor.alloc.Reference;
import reactor.alloc.ReferenceCountingAllocator;
import reactor.fn.Supplier;
import reactor.io.buffer.Buffer;

public class BufferAllocator
implements Allocator<Buffer> {
    private final Allocator<Buffer> delegate;

    public BufferAllocator() {
        this(256, false, Buffer.SMALL_BUFFER_SIZE);
    }

    public BufferAllocator(int poolSize, final boolean direct, final int bufferSize) {
        this.delegate = new ReferenceCountingAllocator<Buffer>(poolSize, new Supplier<Buffer>(){

            public Buffer get() {
                return new Buffer(direct ? ByteBuffer.allocateDirect(bufferSize) : ByteBuffer.allocate(bufferSize));
            }
        });
    }

    @Override
    public Reference<Buffer> allocate() {
        return this.delegate.allocate();
    }

    @Override
    public List<Reference<Buffer>> allocateBatch(int size) {
        return this.delegate.allocateBatch(size);
    }

    @Override
    public void release(List<Reference<Buffer>> batch) {
        this.delegate.release(batch);
    }
}

