/*
 * Decompiled with CFR 0.152.
 */
package reactor.alloc;

import java.util.HashMap;
import reactor.alloc.Allocator;
import reactor.alloc.EventFactorySupplier;
import reactor.alloc.Reference;
import reactor.alloc.ReferenceCountingAllocator;
import reactor.bus.Event;

public abstract class EventAllocator {
    private final Object monitor;
    private final HashMap<Class, Allocator> eventPools = new HashMap();

    public EventAllocator() {
        this(new Class[0]);
    }

    public EventAllocator(Class[] classes) {
        this.monitor = new Object();
        for (Class c : classes) {
            this.eventPools.put(c, this.makeAllocator(c));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Reference<Event<T>> get(Class<T> klass) {
        if (!this.eventPools.containsKey(klass)) {
            Object object = this.monitor;
            synchronized (object) {
                if (!this.eventPools.containsKey(klass)) {
                    this.eventPools.put(klass, this.makeAllocator(klass));
                }
            }
        }
        return this.eventPools.get(klass).allocate();
    }

    protected abstract <T> Allocator<Event<T>> makeAllocator(Class<T> var1);

    public static EventAllocator defaultEventAllocator() {
        return new EventAllocator(){

            @Override
            protected <T> Allocator<Event<T>> makeAllocator(Class<T> klass) {
                return new ReferenceCountingAllocator<Event<T>>(new EventFactorySupplier<T>(klass));
            }
        };
    }
}

