/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import java.util.Map;

public class QueueSpecification {
    protected String name;
    protected boolean durable = false;
    protected boolean exclusive = false;
    protected boolean autoDelete = false;
    protected Map<String, Object> arguments;

    public static QueueSpecification queue() {
        return new NullNameQueueSpecification();
    }

    public static QueueSpecification queue(String name) {
        return new QueueSpecification().name(name);
    }

    public QueueSpecification name(String queue) {
        if (queue == null) {
            return new NullNameQueueSpecification().arguments(this.arguments);
        }
        this.name = queue;
        return this;
    }

    public QueueSpecification durable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public QueueSpecification exclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    public QueueSpecification autoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    public QueueSpecification arguments(Map<String, Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    private static class NullNameQueueSpecification
    extends QueueSpecification {
        NullNameQueueSpecification() {
            this.name = null;
            this.durable = false;
            this.exclusive = true;
            this.autoDelete = true;
        }

        @Override
        public QueueSpecification name(String name) {
            if (name == null) {
                return this;
            }
            return QueueSpecification.queue(name).durable(this.durable).exclusive(this.exclusive).autoDelete(this.autoDelete);
        }

        @Override
        public QueueSpecification durable(boolean durable) {
            if (this.durable != durable) {
                throw new IllegalArgumentException("Once a queue has a null name, durable is always false");
            }
            return this;
        }

        @Override
        public QueueSpecification exclusive(boolean exclusive) {
            if (this.exclusive != exclusive) {
                throw new IllegalArgumentException("Once a queue has a null name, exclusive is always true");
            }
            return this;
        }

        @Override
        public QueueSpecification autoDelete(boolean autoDelete) {
            if (this.autoDelete != autoDelete) {
                throw new IllegalArgumentException("Once a queue has a null name, autoDelete is always true");
            }
            return this;
        }
    }
}

