/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.Delivery;
import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import reactor.core.publisher.FluxSink;
import reactor.rabbitmq.ExceptionHandlers;
import reactor.rabbitmq.Receiver;

public class ConsumeOptions {
    private int qos = 250;
    private FluxSink.OverflowStrategy overflowStrategy = FluxSink.OverflowStrategy.BUFFER;
    private BiFunction<Long, ? super Delivery, Boolean> hookBeforeEmitBiFunction = (requestedFromDownstream, message) -> true;
    private BiFunction<Long, ? super Delivery, Boolean> stopConsumingBiFunction = (requestedFromDownstream, message) -> false;
    private BiConsumer<Receiver.AcknowledgmentContext, Exception> exceptionHandler = new ExceptionHandlers.RetryAcknowledgmentExceptionHandler(Duration.ofSeconds(10L), Duration.ofMillis(200L), ExceptionHandlers.CONNECTION_RECOVERY_PREDICATE);

    public int getQos() {
        return this.qos;
    }

    public ConsumeOptions qos(int qos) {
        if (qos < 0) {
            throw new IllegalArgumentException("QoS must be greater or equal to 0");
        }
        this.qos = qos;
        return this;
    }

    public FluxSink.OverflowStrategy getOverflowStrategy() {
        return this.overflowStrategy;
    }

    public ConsumeOptions overflowStrategy(FluxSink.OverflowStrategy overflowStrategy) {
        this.overflowStrategy = overflowStrategy;
        return this;
    }

    public BiFunction<Long, ? super Delivery, Boolean> getHookBeforeEmitBiFunction() {
        return this.hookBeforeEmitBiFunction;
    }

    public ConsumeOptions hookBeforeEmitBiFunction(BiFunction<Long, ? super Delivery, Boolean> hookBeforeEmit) {
        this.hookBeforeEmitBiFunction = hookBeforeEmit;
        return this;
    }

    public BiFunction<Long, ? super Delivery, Boolean> getStopConsumingBiFunction() {
        return this.stopConsumingBiFunction;
    }

    public ConsumeOptions stopConsumingBiFunction(BiFunction<Long, ? super Delivery, Boolean> stopConsumingBiFunction) {
        this.stopConsumingBiFunction = stopConsumingBiFunction;
        return this;
    }

    public ConsumeOptions exceptionHandler(BiConsumer<Receiver.AcknowledgmentContext, Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public BiConsumer<Receiver.AcknowledgmentContext, Exception> getExceptionHandler() {
        return this.exceptionHandler;
    }
}

