/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.concurrent.Callable;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.IdempotentClosedConnection;

public abstract class Utils {
    public static Mono<? extends Connection> singleConnectionMono(ConnectionFactory connectionFactory) {
        return Utils.singleConnectionMono(connectionFactory, cf -> cf.newConnection());
    }

    public static Mono<? extends Connection> singleConnectionMono(ConnectionFactory cf, ExceptionFunction<ConnectionFactory, ? extends Connection> function) {
        return Mono.fromCallable(() -> new IdempotentClosedConnection((Connection)function.apply(cf))).cache();
    }

    public static Mono<? extends Connection> singleConnectionMono(Callable<? extends Connection> supplier) {
        return Mono.fromCallable(() -> new IdempotentClosedConnection((Connection)supplier.call())).cache();
    }

    @FunctionalInterface
    public static interface ExceptionFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

