/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.Channel;
import java.time.Duration;
import java.util.function.BiConsumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.rabbitmq.ChannelPool;
import reactor.rabbitmq.ExceptionHandlers;
import reactor.rabbitmq.Sender;

public class SendOptions {
    private BiConsumer<Sender.SendContext, Exception> exceptionHandler = new ExceptionHandlers.RetrySendingExceptionHandler(Duration.ofSeconds(10L), Duration.ofMillis(200L), ExceptionHandlers.CONNECTION_RECOVERY_PREDICATE);
    private Mono<? extends Channel> channelMono;
    private BiConsumer<SignalType, Channel> channelCloseHandler;

    public BiConsumer<Sender.SendContext, Exception> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public SendOptions exceptionHandler(BiConsumer<Sender.SendContext, Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public Mono<? extends Channel> getChannelMono() {
        return this.channelMono;
    }

    public SendOptions channelMono(Mono<? extends Channel> channelMono) {
        this.channelMono = channelMono;
        return this;
    }

    public BiConsumer<SignalType, Channel> getChannelCloseHandler() {
        return this.channelCloseHandler;
    }

    public SendOptions channelCloseHandler(BiConsumer<SignalType, Channel> channelCloseHandler) {
        this.channelCloseHandler = channelCloseHandler;
        return this;
    }

    public SendOptions channelPool(ChannelPool channelPool) {
        this.channelMono = channelPool.getChannelMono();
        this.channelCloseHandler = channelPool.getChannelCloseHandler();
        return this;
    }
}

