/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Delivery;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.rabbitmq.RabbitFluxException;

public class AcknowledgableDelivery
extends Delivery {
    private final Channel channel;
    private final AtomicBoolean notAckedOrNacked = new AtomicBoolean(true);

    public AcknowledgableDelivery(Delivery delivery, Channel channel) {
        super(delivery.getEnvelope(), delivery.getProperties(), delivery.getBody());
        this.channel = channel;
    }

    public void ack(boolean multiple) {
        if (this.notAckedOrNacked.getAndSet(false)) {
            try {
                this.channel.basicAck(this.getEnvelope().getDeliveryTag(), multiple);
            }
            catch (RuntimeException e) {
                this.notAckedOrNacked.set(true);
                throw e;
            }
            catch (IOException e) {
                this.notAckedOrNacked.set(true);
                throw new RabbitFluxException(e);
            }
        }
    }

    public void ack() {
        this.ack(false);
    }

    public void nack(boolean multiple, boolean requeue) {
        if (this.notAckedOrNacked.getAndSet(false)) {
            try {
                this.channel.basicNack(this.getEnvelope().getDeliveryTag(), multiple, requeue);
            }
            catch (RuntimeException e) {
                this.notAckedOrNacked.set(true);
                throw e;
            }
            catch (IOException e) {
                this.notAckedOrNacked.set(true);
                throw new RabbitFluxException(e);
            }
        }
    }

    public void nack(boolean requeue) {
        this.nack(false, requeue);
    }
}

