/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq.samples;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.rabbitmq.OutboundMessage;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.RabbitFlux;
import reactor.rabbitmq.Sender;

public class SampleSender {
    private static final String QUEUE = "demo-queue";
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleSender.class);
    private final Sender sender = RabbitFlux.createSender();

    public void send(String queue, int count, CountDownLatch latch) {
        Flux confirmations = this.sender.sendWithPublishConfirms((Publisher)Flux.range((int)1, (int)count).map(i -> new OutboundMessage("", queue, ("Message_" + i).getBytes())));
        this.sender.declareQueue(QueueSpecification.queue((String)queue)).thenMany((Publisher)confirmations).doOnError(e -> LOGGER.error("Send failed", e)).subscribe(r -> {
            if (r.isAck()) {
                LOGGER.info("Message {} sent successfully", (Object)new String(r.getOutboundMessage().getBody()));
                latch.countDown();
            }
        });
    }

    public void close() {
        this.sender.close();
    }

    public static void main(String[] args) throws Exception {
        int count = 20;
        CountDownLatch latch = new CountDownLatch(count);
        SampleSender sender = new SampleSender();
        sender.send(QUEUE, count, latch);
        latch.await(10L, TimeUnit.SECONDS);
        sender.close();
    }
}

