/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.io.Externalizable;
import java.io.IOException;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;

public class ExternalizableMarshaller<E extends Externalizable>
implements BytesMarshaller<E> {
    private static final long serialVersionUID = 0L;
    @NotNull
    private final Class<E> classMarshaled;

    public ExternalizableMarshaller(@NotNull Class<E> classMarshaled) {
        this.classMarshaled = classMarshaled;
    }

    public final Class<E> marshaledClass() {
        return this.classMarshaled;
    }

    @Override
    public void write(Bytes bytes, @NotNull E e) {
        try {
            e.writeExternal(bytes);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public E read(Bytes bytes) {
        return this.read(bytes, (E)null);
    }

    @Override
    @Nullable
    public E read(Bytes bytes, @Nullable E e) {
        try {
            if (e == null) {
                e = this.getInstance();
            }
            e.readExternal(bytes);
            return e;
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    @NotNull
    protected E getInstance() throws Exception {
        return (E)((Externalizable)NativeBytes.UNSAFE.allocateInstance(this.classMarshaled));
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((ExternalizableMarshaller)obj).classMarshaled == this.classMarshaled;
    }

    public int hashCode() {
        return this.classMarshaled.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{marshaledClass=" + this.classMarshaled + "}";
    }
}

