/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.collection;

import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectStore;

public class DirectBitSetBuilder {
    private boolean assertions = false;
    private boolean threadSafe = true;

    public DirectBitSetBuilder() {
        if (!$assertionsDisabled) {
            this.assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }

    public DirectBitSetBuilder assertions(boolean assertions) {
        this.assertions = assertions;
        return this;
    }

    public boolean assertions() {
        return this.assertions;
    }

    public DirectBitSetBuilder threadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
        return this;
    }

    public boolean threadSafe() {
        return this.threadSafe;
    }

    public DirectBitSet create(long size) {
        return DirectBitSetBuilder.wrap(DirectStore.allocate(size + 7L >>> 3).bytes());
    }

    static DirectBitSet wrap(Bytes bytes) {
        return new ATSDirectBitSet(bytes);
    }
}

