/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;
import reactor.util.annotation.Nullable;

final class FluxWindowWhen<T, U, V>
extends FluxOperator<T, Flux<T>> {
    final Publisher<U> start;
    final Function<? super U, ? extends Publisher<V>> end;
    final Supplier<? extends Queue<Object>> drainQueueSupplier;
    final Supplier<? extends Queue<T>> processorQueueSupplier;

    FluxWindowWhen(Flux<? extends T> source, Publisher<U> start, Function<? super U, ? extends Publisher<V>> end, Supplier<? extends Queue<Object>> drainQueueSupplier, Supplier<? extends Queue<T>> processorQueueSupplier) {
        super(source);
        this.start = Objects.requireNonNull(start, "start");
        this.end = Objects.requireNonNull(end, "end");
        this.drainQueueSupplier = Objects.requireNonNull(drainQueueSupplier, "drainQueueSupplier");
        this.processorQueueSupplier = Objects.requireNonNull(processorQueueSupplier, "processorQueueSupplier");
    }

    @Override
    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void subscribe(CoreSubscriber<? super Flux<T>> actual) {
        Queue<Object> q = this.drainQueueSupplier.get();
        WindowStartEndMainSubscriber main = new WindowStartEndMainSubscriber(actual, q, this.end, this.processorQueueSupplier);
        actual.onSubscribe(main);
        this.start.subscribe(main.starter);
        this.source.subscribe(main);
    }

    static final class NewWindow<U> {
        final U value;

        public NewWindow(U value) {
            this.value = value;
        }
    }

    static final class WindowStartEndEnder<T, V>
    extends Operators.DeferredSubscription
    implements CoreSubscriber<V> {
        final WindowStartEndMainSubscriber<T, ?, V> main;
        final UnicastProcessor<T> window;

        WindowStartEndEnder(WindowStartEndMainSubscriber<T, ?, V> main, UnicastProcessor<T> window) {
            this.main = main;
            this.window = window;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(V t) {
            this.cancel();
            this.main.endSignal(this);
        }

        public void onError(Throwable t) {
            this.main.endError(t);
        }

        public void onComplete() {
            this.main.endSignal(this);
        }
    }

    static final class WindowStartEndStarter<T, U, V>
    extends Operators.DeferredSubscription
    implements CoreSubscriber<U> {
        final WindowStartEndMainSubscriber<T, U, V> main;

        WindowStartEndStarter(WindowStartEndMainSubscriber<T, U, V> main) {
            this.main = main;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(U t) {
            this.main.starterNext(t);
        }

        public void onError(Throwable t) {
            this.main.starterError(t);
        }

        public void onComplete() {
            this.main.starterComplete();
        }
    }

    static final class WindowStartEndMainSubscriber<T, U, V>
    implements InnerOperator<T, Flux<T>>,
    Disposable {
        final CoreSubscriber<? super Flux<T>> actual;
        final Queue<Object> queue;
        final WindowStartEndStarter<T, U, V> starter;
        final Function<? super U, ? extends Publisher<V>> end;
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        volatile long requested;
        static final AtomicLongFieldUpdater<WindowStartEndMainSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, "requested");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowStartEndMainSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, "wip");
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<WindowStartEndMainSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, Subscription.class, "s");
        volatile int cancelled;
        static final AtomicIntegerFieldUpdater<WindowStartEndMainSubscriber> CANCELLED = AtomicIntegerFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, "cancelled");
        volatile int windowCount;
        static final AtomicIntegerFieldUpdater<WindowStartEndMainSubscriber> WINDOW_COUNT = AtomicIntegerFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, "windowCount");
        Set<WindowStartEndEnder<T, V>> windowEnds;
        Set<UnicastProcessor<T>> windows;
        volatile boolean done;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<WindowStartEndMainSubscriber, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, Throwable.class, "error");

        WindowStartEndMainSubscriber(CoreSubscriber<? super Flux<T>> actual, Queue<Object> queue, Function<? super U, ? extends Publisher<V>> end, Supplier<? extends Queue<T>> processorQueueSupplier) {
            this.actual = actual;
            this.queue = queue;
            this.starter = new WindowStartEndStarter(this);
            this.end = end;
            this.windowEnds = new HashSet<WindowStartEndEnder<T, V>>();
            this.windows = new HashSet<UnicastProcessor<T>>();
            this.processorQueueSupplier = processorQueueSupplier;
            WINDOW_COUNT.lazySet(this, 1);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super Flux<T>> actual() {
            return this.actual;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            WindowStartEndMainSubscriber windowStartEndMainSubscriber = this;
            synchronized (windowStartEndMainSubscriber) {
                this.queue.offer(t);
            }
            this.drain();
        }

        public void onError(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.drain();
            } else {
                Operators.onErrorDropped(t, this.actual.currentContext());
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.closeMain(false);
            this.starter.cancel();
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.addCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            this.starter.cancel();
            this.closeMain(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void starterNext(U u) {
            NewWindow<U> nw = new NewWindow<U>(u);
            WindowStartEndMainSubscriber windowStartEndMainSubscriber = this;
            synchronized (windowStartEndMainSubscriber) {
                this.queue.offer(nw);
            }
            this.drain();
        }

        void starterError(Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                this.drain();
            } else {
                Operators.onErrorDropped(e, this.actual.currentContext());
            }
        }

        void starterComplete() {
            if (this.done) {
                return;
            }
            this.closeMain(false);
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endSignal(WindowStartEndEnder<T, V> end) {
            this.remove(end);
            WindowStartEndMainSubscriber windowStartEndMainSubscriber = this;
            synchronized (windowStartEndMainSubscriber) {
                this.queue.offer(end);
            }
            this.drain();
        }

        void endError(Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                this.drain();
            } else {
                Operators.onErrorDropped(e, this.actual.currentContext());
            }
        }

        void closeMain(boolean cancel) {
            if (cancel) {
                if (CANCELLED.compareAndSet(this, 0, 1)) {
                    this.dispose();
                }
            } else {
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            if (WINDOW_COUNT.decrementAndGet(this) == 0) {
                if (this.cancelled == 0) {
                    Operators.terminate(S, this);
                } else {
                    this.s.cancel();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled == 1 || this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(WindowStartEndEnder<T, V> ender) {
            WindowStartEndStarter<T, U, V> windowStartEndStarter = this.starter;
            synchronized (windowStartEndStarter) {
                Set<WindowStartEndEnder<T, V>> set = this.windowEnds;
                if (set != null) {
                    set.add(ender);
                    return true;
                }
            }
            ender.cancel();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(WindowStartEndEnder<T, V> ender) {
            WindowStartEndStarter<T, U, V> windowStartEndStarter = this.starter;
            synchronized (windowStartEndStarter) {
                Set<WindowStartEndEnder<T, V>> set = this.windowEnds;
                if (set != null) {
                    set.remove(ender);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAll() {
            Set<WindowStartEndEnder<T, V>> set;
            WindowStartEndStarter<T, U, V> windowStartEndStarter = this.starter;
            synchronized (windowStartEndStarter) {
                set = this.windowEnds;
                if (set == null) {
                    return;
                }
                this.windowEnds = null;
            }
            for (Subscription subscription : set) {
                subscription.cancel();
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            CoreSubscriber<? super Flux<T>> a = this.actual;
            Queue<Object> q = this.queue;
            int missed = 1;
            block2: while (true) {
                Throwable e;
                if ((e = this.error) != null) {
                    e = Exceptions.terminate(ERROR, this);
                    if (e != Exceptions.TERMINATED) {
                        Operators.terminate(S, this);
                        this.starter.cancel();
                        this.removeAll();
                        for (UnicastProcessor<T> w : this.windows) {
                            w.onError(e);
                        }
                        this.windows = null;
                        q.clear();
                        a.onError(e);
                    }
                    return;
                }
                if (this.done || this.windowCount == 0 && this.cancelled == 0) {
                    this.removeAll();
                    for (UnicastProcessor<T> w : this.windows) {
                        w.onComplete();
                    }
                    this.windows = null;
                    a.onComplete();
                    return;
                }
                if (this.windowCount == 0) {
                    this.removeAll();
                    this.dispose();
                    return;
                }
                Object o = q.poll();
                if (o != null) {
                    if (o instanceof NewWindow) {
                        Publisher<V> p;
                        if (this.cancelled != 0 || this.windowCount == 0 || this.done) continue;
                        NewWindow newWindow = (NewWindow)o;
                        Queue<T> pq = this.processorQueueSupplier.get();
                        try {
                            p = Objects.requireNonNull(this.end.apply(newWindow.value), "The end returned a null publisher");
                        }
                        catch (Throwable ex) {
                            Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this.s, ex, newWindow.value, this.actual.currentContext()));
                            continue;
                        }
                        WINDOW_COUNT.getAndIncrement(this);
                        UnicastProcessor<T> w = new UnicastProcessor<T>(pq, this);
                        WindowStartEndEnder end = new WindowStartEndEnder(this, w);
                        this.windows.add(w);
                        if (!this.add(end)) continue;
                        long r = this.requested;
                        if (r != 0L) {
                            a.onNext(w);
                            if (r != Long.MAX_VALUE) {
                                REQUESTED.decrementAndGet(this);
                            }
                        } else {
                            Exceptions.addThrowable(ERROR, this, Exceptions.failWithOverflow("Could not emit window due to lack of requests"));
                            continue;
                        }
                        p.subscribe(end);
                        continue;
                    }
                    if (o instanceof WindowStartEndEnder) {
                        WindowStartEndEnder end = (WindowStartEndEnder)o;
                        end.window.onComplete();
                        continue;
                    }
                    Object v = o;
                    Iterator<UnicastProcessor<T>> iterator = this.windows.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        UnicastProcessor<Object> w = iterator.next();
                        w.onNext(v);
                    }
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }
    }
}

