/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Random;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public enum IOTools {

    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static void close(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(@NotNull Iterable<? extends Closeable> closeables) {
        for (Closeable closeable : closeables) {
            IOTools.close(closeable);
        }
    }

    public static int stopBitLength(long l) {
        if (l < 0L) {
            return IOTools.stopBitLength(l ^ 0xFFFFFFFFFFFFFFFFL) + 1;
        }
        int count = 1;
        while (l >= 128L) {
            l >>>= 7;
            ++count;
        }
        return count;
    }

    public static void deleteDir(String dirPath) {
        IOTools.deleteDir(new File(dirPath));
    }

    private static void deleteDir(File dir) {
        File[] files;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    IOTools.deleteDir(file);
                    continue;
                }
                if (file.delete()) continue;
                LoggerFactory.getLogger(IOTools.class).info("... unable to delete {}", (Object)file);
            }
        }
        dir.delete();
    }

    public static void clean(ByteBuffer bb) {
        Cleaner cl;
        if (bb instanceof DirectBuffer && (cl = ((DirectBuffer)((Object)bb)).cleaner()) != null) {
            cl.clean();
        }
    }

    public static int freePort() {
        int min = 48000;
        int max = 65535;
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            int port = rand.nextInt(max - min + 1) + min;
            try {
                new Socket("localhost", port).close();
                continue;
            }
            catch (IOException e) {
                return port;
            }
        }
        throw new IllegalStateException("Unable to find a random free port");
    }
}

