/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.nio.channels.SelectionKey;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import net.openhft.lang.Maths;
import org.jetbrains.annotations.NotNull;

public class VanillaSelectionKeySet
extends AbstractSet<SelectionKey> {
    private static final int MIN_KEYS = 16;
    private SelectionKey[] keys = new SelectionKey[16];
    private int size = 0;

    VanillaSelectionKeySet() {
        Arrays.fill(this.keys, null);
    }

    @Override
    public boolean add(SelectionKey key) {
        if (key == null) {
            return false;
        }
        this.ensureCapacity(this.size + 1);
        this.keys[this.size++] = key;
        return true;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.keys.length && this.keys[i] != null; ++i) {
            this.keys[i] = null;
        }
        this.size = 0;
    }

    public SelectionKey[] keys() {
        return this.keys;
    }

    public int capacity() {
        return this.keys.length;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof SelectionKey) {
            SelectionKey key = (SelectionKey)o;
            for (int i = 0; i < this.keys.length && this.keys[i] != null; ++i) {
                if (key == this.keys[i]) {
                    return true;
                }
                if (this.keys[i].channel() != key.channel() || this.keys[i].interestOps() != key.interestOps()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<SelectionKey> iterator() {
        throw new UnsupportedOperationException();
    }

    private void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity < 0) {
            String s = String.format("Insufficient capacity: length=%d required=%d", this.keys.length, requiredCapacity);
            throw new IllegalStateException(s);
        }
        if (requiredCapacity > this.keys.length) {
            int newCapacity = Maths.nextPower2(16, requiredCapacity);
            this.keys = Arrays.copyOf(this.keys, newCapacity);
        }
    }
}

