/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.tcp.Attached;
import net.openhft.chronicle.tcp.SourceTcp;
import net.openhft.chronicle.tcp.VanillaSelectionKeySet;
import net.openhft.chronicle.tcp.VanillaSelector;
import net.openhft.lang.thread.NamedThreadFactory;

public final class SourceTcpAcceptor
extends SourceTcp {
    public SourceTcpAcceptor(ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder) {
        super("source-acceptor", builder, new ThreadPoolExecutor(builder.acceptorDefaultThreads() + 1, Math.max(builder.acceptorMaxThreads(), builder.acceptorMaxThreads() + 1), builder.acceptorThreadPoolkeepAliveTime(), builder.acceptorThreadPoolkeepAliveTimeUnit(), new SynchronousQueue<Runnable>(), new NamedThreadFactory("chronicle-source", true)));
    }

    @Override
    protected Runnable createHandler() {
        return new Runnable(){

            @Override
            public void run() {
                ServerSocketChannel socketChannel = null;
                try {
                    socketChannel = ServerSocketChannel.open();
                    socketChannel.configureBlocking(false);
                    ServerSocket socket = socketChannel.socket();
                    socket.setReuseAddress(true);
                    socket.bind(SourceTcpAcceptor.this.builder.bindAddress(), SourceTcpAcceptor.this.builder.acceptorMaxBacklog());
                    SourceTcpAcceptor.this.builder.connectionListener().onListen(socketChannel);
                    VanillaSelector selector = new VanillaSelector().open().register(socketChannel, 16, new Attached());
                    long selectTimeout = SourceTcpAcceptor.this.builder.selectTimeout();
                    VanillaSelectionKeySet selectionKeys = selector.vanillaSelectionKeys();
                    while (SourceTcpAcceptor.this.running.get()) {
                        Object keys;
                        int nbKeys = selector.select(0, selectTimeout);
                        if (nbKeys <= 0) continue;
                        if (selectionKeys != null) {
                            keys = selectionKeys.keys();
                            int size = selectionKeys.size();
                            for (int k = 0; k < size; ++k) {
                                Object key = keys[k];
                                if (key == null || !((SelectionKey)key).isAcceptable()) continue;
                                SocketChannel channel = socketChannel.accept();
                                SourceTcpAcceptor.this.logger.info("Accepted connection from: {}", (Object)channel.getRemoteAddress());
                                try {
                                    SourceTcpAcceptor.this.executor.execute(SourceTcpAcceptor.this.createSessionHandler(channel));
                                    continue;
                                }
                                catch (RejectedExecutionException rejected) {
                                    SourceTcpAcceptor.this.logger.trace("Unable to start session", (Throwable)rejected);
                                }
                            }
                            selectionKeys.clear();
                            continue;
                        }
                        keys = selector.selectionKeys();
                        Iterator i$ = keys.iterator();
                        while (i$.hasNext()) {
                            SelectionKey key = (SelectionKey)i$.next();
                            if (!key.isAcceptable()) continue;
                            SocketChannel channel = socketChannel.accept();
                            SourceTcpAcceptor.this.logger.info("Accepted connection from: {}", (Object)channel.getRemoteAddress());
                            try {
                                SourceTcpAcceptor.this.executor.execute(SourceTcpAcceptor.this.createSessionHandler(channel));
                            }
                            catch (RejectedExecutionException rejected) {
                                SourceTcpAcceptor.this.logger.trace("Unable to start session", (Throwable)rejected);
                            }
                        }
                        keys.clear();
                    }
                    selector.close();
                    socketChannel.close();
                }
                catch (IOException e) {
                    SourceTcpAcceptor.this.builder.connectionListener().onError(socketChannel, e);
                    SourceTcpAcceptor.this.logger.warn("", (Throwable)e);
                }
            }
        };
    }

    @Override
    public boolean isLocalhost() {
        return true;
    }
}

