/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.File;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.ExcerptComparator;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.tools.CheckedExcerpt;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.VanillaMappedBlocks;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.JDKZObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;

public class IndexedChronicle
implements Chronicle {
    @NotNull
    final VanillaMappedBlocks indexFileCache;
    @NotNull
    final VanillaMappedBlocks dataFileCache;
    @NotNull
    final ChronicleQueueBuilder.IndexedChronicleQueueBuilder builder;
    private final String basePath;
    private long lastWrittenIndex = -1L;
    private volatile boolean closed = false;

    IndexedChronicle(@NotNull ChronicleQueueBuilder.IndexedChronicleQueueBuilder builder) throws IOException {
        this.builder = builder.clone();
        this.basePath = builder.path().getAbsolutePath();
        File parentFile = builder.path().getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        this.indexFileCache = VanillaMappedBlocks.readWrite(new File(this.basePath + ".index"), builder.indexBlockSize());
        this.dataFileCache = VanillaMappedBlocks.readWrite(new File(this.basePath + ".data"), builder.dataBlockSize());
        this.findTheLastIndex();
    }

    public void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException(this.basePath + " is closed");
        }
    }

    public ChronicleQueueBuilder.IndexedChronicleQueueBuilder builder() {
        return this.builder;
    }

    public long findTheLastIndex() {
        this.lastWrittenIndex = this.findTheLastIndex0();
        return this.lastWrittenIndex;
    }

    private long findTheLastIndex0() {
        long size = 0L;
        try {
            size = this.indexFileCache.size();
        }
        catch (Exception e) {
            return -1L;
        }
        if (size <= 0L) {
            return -1L;
        }
        int indexBlockSize = this.builder.indexBlockSize();
        for (long block = size / (long)indexBlockSize - 1L; block >= 0L; --block) {
            VanillaMappedBytes mbb = null;
            try {
                mbb = this.indexFileCache.acquire(block);
            }
            catch (IOException e) {
                continue;
            }
            if (block > 0L && mbb.readLong(0L) == 0L) {
                mbb.release();
                continue;
            }
            int cacheLineSize = this.builder.cacheLineSize();
            for (int pos = 0; pos < indexBlockSize; pos += cacheLineSize) {
                if (pos + cacheLineSize < indexBlockSize && mbb.readLong(pos + cacheLineSize) != 0L) continue;
                int pos2 = 8;
                for (pos2 = 8; pos2 < cacheLineSize && mbb.readInt(pos + pos2) != 0; pos2 += 4) {
                }
                mbb.release();
                return (block * (long)indexBlockSize + (long)pos) / (long)cacheLineSize * (long)(cacheLineSize / 4 - 2) + (long)(pos2 / 4) - 3L;
            }
            mbb.release();
            return (block + 1L) * (long)indexBlockSize / (long)cacheLineSize * (long)(cacheLineSize / 4 - 2);
        }
        return -1L;
    }

    @Override
    public long size() {
        return this.lastWrittenIndex + 1L;
    }

    @Override
    public void clear() {
        new File(this.basePath + ".index").delete();
        new File(this.basePath + ".data").delete();
    }

    @Override
    public String name() {
        return this.basePath;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.indexFileCache.close();
        this.dataFileCache.close();
    }

    @Override
    @NotNull
    public Excerpt createExcerpt() throws IOException {
        IndexedExcerpt excerpt = new IndexedExcerpt();
        return !this.builder.useCheckedExcerpt() ? excerpt : new CheckedExcerpt(excerpt);
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() throws IOException {
        return new IndexedExcerptTailer();
    }

    @Override
    @NotNull
    public ExcerptAppender createAppender() throws IOException {
        IndexedExcerptAppender appender = new IndexedExcerptAppender();
        return !this.builder.useCheckedExcerpt() ? appender : new CheckedExcerpt(appender);
    }

    @Override
    public long lastWrittenIndex() {
        return this.lastWrittenIndex;
    }

    @Override
    public long lastIndex() {
        return this.findTheLastIndex0();
    }

    void incrSize() {
        ++this.lastWrittenIndex;
    }

    private class IndexedExcerptTailer
    extends AbstractIndexedExcerpt
    implements ExcerptTailer {
        IndexedExcerptTailer() throws IOException {
        }

        @Override
        public boolean index(long l) {
            IndexedChronicle.this.checkNotClosed();
            return this.indexForRead(l);
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() {
            super.toEndForRead0();
            return this;
        }

        @Override
        @NotNull
        public ExcerptTailer toStart() {
            super.toStart0();
            return this;
        }

        @Override
        public boolean nextIndex() {
            IndexedChronicle.this.checkNotClosed();
            this.checkNextLine();
            long offset = UNSAFE.getInt(null, this.indexPositionAddr);
            if (offset == 0L && (offset = (long)UNSAFE.getIntVolatile(null, this.indexPositionAddr)) == 0L) {
                return false;
            }
            ++this.index;
            return this.nextIndex0(offset) || this.nextIndex1();
        }

        private boolean nextIndex1() {
            this.checkNextLine();
            long offset = UNSAFE.getInt(null, this.indexPositionAddr);
            if (offset == 0L) {
                offset = UNSAFE.getIntVolatile(null, this.indexPositionAddr);
            }
            if (offset == 0L) {
                return false;
            }
            ++this.index;
            return this.nextIndex0(offset);
        }

        private void checkNextLine() {
            switch ((int)(this.indexPositionAddr & (long)this.cacheLineMask)) {
                case 0: {
                    this.newIndexLine();
                    this.indexPositionAddr += 8L;
                    break;
                }
                case 4: {
                    throw new AssertionError();
                }
            }
        }

        private void newIndexLine() {
            if (this.indexPositionAddr >= this.indexStartAddr + (long)this.indexBlockSize) {
                try {
                    this.loadNextIndexBuffer();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        private boolean nextIndex0(long offset) {
            boolean present = true;
            boolean bl = this.padding = offset < 0L;
            if (this.padding) {
                present = false;
                offset = -offset;
            }
            this.checkNewIndexLine2();
            this.startAddr = this.positionAddr = this.limitAddr;
            this.setLimitAddr(offset);
            assert (this.limitAddr >= this.startAddr || !present && this.limitAddr == this.startAddr);
            this.indexPositionAddr += 4L;
            return present;
        }

        private void setLimitAddr(long offset) {
            long offsetInThisBuffer = this.indexBaseForLine + offset - this.dataStartOffset;
            if (offsetInThisBuffer > (long)this.dataBlockSize) {
                try {
                    this.loadNextDataBuffer(offsetInThisBuffer);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                offsetInThisBuffer = this.indexBaseForLine + offset - this.dataStartOffset;
            }
            assert (offsetInThisBuffer >= 0L && offsetInThisBuffer <= (long)this.dataBlockSize) : "index: " + this.index + ", offsetInThisBuffer: " + offsetInThisBuffer;
            this.limitAddr = this.dataStartAddr + offsetInThisBuffer;
        }

        void checkNewIndexLine2() {
            if ((this.indexPositionAddr & (long)this.cacheLineMask) == 8L) {
                this.indexBaseForLine = UNSAFE.getLongVolatile(null, this.indexPositionAddr - 8L);
                assert (this.index <= (long)this.indexEntriesPerLine || this.indexBaseForLine > 0L) : "index: " + this.index + " indexBaseForLine: " + this.indexBaseForLine;
                this.setLimitAddr(0L);
            }
        }
    }

    private class IndexedExcerptAppender
    extends AbstractIndexedExcerpt
    implements ExcerptAppender {
        private boolean nextSynchronous;

        IndexedExcerptAppender() throws IOException {
            super.toEndForAppend0();
        }

        @Override
        public void startExcerpt() {
            this.startExcerpt(IndexedChronicle.this.builder.messageCapacity());
        }

        @Override
        public void startExcerpt(long capacity) {
            IndexedChronicle.this.checkNotClosed();
            if (this.index != this.size()) {
                super.toEndForAppend0();
            }
            if (capacity >= (long)IndexedChronicle.this.builder.dataBlockSize()) {
                throw new IllegalArgumentException("Capacity too large " + capacity + " >= " + IndexedChronicle.this.builder.dataBlockSize());
            }
            if (this.positionAddr + capacity > this.dataStartAddr + (long)this.dataBlockSize) {
                this.checkNewIndexLine();
                this.writePaddedEntry();
                try {
                    this.loadNextDataBuffer();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.checkNewIndexLine();
            this.startAddr = this.positionAddr;
            this.limitAddr = this.positionAddr + capacity;
            this.finished = false;
            this.nextSynchronous = IndexedChronicle.this.builder.synchronous();
        }

        @Override
        public void nextSynchronous(boolean nextSynchronous) {
            this.nextSynchronous = nextSynchronous;
        }

        @Override
        public long lastWrittenIndex() {
            return IndexedChronicle.this.lastWrittenIndex();
        }

        @Override
        public boolean nextSynchronous() {
            return this.nextSynchronous;
        }

        @Override
        public void addPaddedEntry() {
            if (this.index != this.lastWrittenIndex()) {
                super.toEndForAppend0();
            }
            this.checkNewIndexLine();
            this.writePaddedEntry();
            try {
                this.loadNextDataBuffer();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.checkNewIndexLine();
            this.finished = true;
        }

        private void writePaddedEntry() {
            int size = (int)((long)this.dataBlockSize + this.dataStartOffset - this.indexBaseForLine);
            assert (size >= 0);
            if (size == 0) {
                return;
            }
            this.appendIndexPaddingEntry(size);
            this.indexPositionAddr += 4L;
            ++this.index;
            IndexedChronicle.this.incrSize();
        }

        private void appendIndexPaddingEntry(int size) {
            assert (this.index < (long)this.indexEntriesPerLine || UNSAFE.getLong(this.indexPositionAddr & (long)(~this.cacheLineMask)) != 0L) : "index: " + this.index + ", no start of line set.";
            UNSAFE.putInt(this.indexPositionAddr, -size);
        }

        @Override
        public void finish() {
            if (this.finished) {
                throw new IllegalStateException("Not started");
            }
            super.finish();
            if (this.index != IndexedChronicle.this.size()) {
                throw new ConcurrentModificationException("Chronicle appended by more than one Appender at the same time, index=" + this.index + ", size=" + this.chronicle().size());
            }
            long offsetInBlock = this.positionAddr - this.dataStartAddr;
            assert (offsetInBlock >= 0L && offsetInBlock <= (long)this.dataBlockSize);
            int relativeOffset = (int)(this.dataStartOffset + offsetInBlock - this.indexBaseForLine);
            assert (relativeOffset >= 0);
            this.writeIndexEntry(relativeOffset);
            this.indexPositionAddr += 4L;
            ++this.index;
            IndexedChronicle.this.incrSize();
            if ((this.indexPositionAddr & (long)this.cacheLineMask) == 0L && this.indexPositionAddr - this.indexStartAddr < (long)this.indexBlockSize) {
                this.indexBaseForLine += (long)relativeOffset;
                this.appendStartOfLine();
            }
            if (this.nextSynchronous) {
                assert (this.dataBuffer != null);
                this.dataBuffer.force();
                assert (this.indexBuffer != null);
                this.indexBuffer.force();
            }
        }

        private void writeIndexEntry(int relativeOffset) {
            UNSAFE.putOrderedInt(null, this.indexPositionAddr, relativeOffset);
        }

        void checkNewIndexLine() {
            switch ((int)(this.indexPositionAddr & (long)this.cacheLineMask)) {
                case 0: {
                    this.newIndexLine();
                    break;
                }
                case 4: {
                    throw new AssertionError();
                }
            }
        }

        void newIndexLine() {
            if (this.indexPositionAddr >= this.indexStartAddr + (long)this.indexBlockSize) {
                try {
                    this.loadNextIndexBuffer();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.indexBaseForLine = this.positionAddr - this.dataStartAddr + this.dataStartOffset;
            assert ((this.index == 0L || this.indexBaseForLine > 0L) && this.indexBaseForLine < 0x1000000000000L) : "dataPositionAtStartOfLine out of bounds, was " + this.indexBaseForLine;
            this.appendStartOfLine();
        }

        private void appendStartOfLine() {
            UNSAFE.putLong(this.indexPositionAddr, this.indexBaseForLine);
            this.indexPositionAddr += 8L;
        }
    }

    private class IndexedExcerpt
    extends AbstractIndexedExcerpt
    implements Excerpt {
        IndexedExcerpt() throws IOException {
        }

        public void startExcerpt(long capacity) {
            IndexedChronicle.this.checkNotClosed();
            if (this.positionAddr + capacity > this.dataStartAddr + (long)this.dataBlockSize) {
                this.checkNewIndexLine();
                this.writePaddedEntry();
                try {
                    this.loadNextDataBuffer();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.checkNewIndexLine();
            this.startAddr = this.positionAddr;
            this.limitAddr = this.positionAddr + capacity;
            this.finished = false;
        }

        private void writePaddedEntry() {
            int size = (int)((long)this.dataBlockSize + this.dataStartOffset - this.indexBaseForLine);
            assert (size >= 0);
            if (size == 0) {
                return;
            }
            this.checkNewIndexLine();
            this.writePaddingIndexEntry(size);
            this.indexPositionAddr += 4L;
        }

        private void writePaddingIndexEntry(int size) {
            UNSAFE.putInt(this.indexPositionAddr, -size);
        }

        @Override
        public boolean index(long l) {
            IndexedChronicle.this.checkNotClosed();
            return this.indexForRead(l);
        }

        @Override
        public void finish() {
            super.finish();
            if (IndexedChronicle.this.builder.synchronous()) {
                if (this.dataBuffer != null) {
                    this.dataBuffer.force();
                }
                if (this.indexBuffer != null) {
                    this.indexBuffer.force();
                }
            }
        }

        void checkNewIndexLine() {
            switch ((int)(this.indexPositionAddr & (long)this.cacheLineMask)) {
                case 0: {
                    this.newIndexLine();
                    break;
                }
                case 4: {
                    throw new AssertionError();
                }
            }
        }

        void newIndexLine() {
            if (this.indexPositionAddr >= this.indexStartAddr + (long)this.indexBlockSize) {
                try {
                    this.loadNextIndexBuffer();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.indexBaseForLine = this.positionAddr - this.dataStartAddr + this.dataStartOffset;
            assert (this.indexBaseForLine >= 0L && this.indexBaseForLine < 0x1000000000000L) : "dataPositionAtStartOfLine out of bounds, was " + this.indexBaseForLine;
            this.appendToIndex();
            this.indexPositionAddr += 8L;
        }

        private void appendToIndex() {
            UNSAFE.putLong(this.indexPositionAddr, this.indexBaseForLine);
        }

        @Override
        @NotNull
        public Excerpt toStart() {
            super.toStart0();
            return this;
        }

        @Override
        @NotNull
        public Excerpt toEnd() {
            super.toEndForRead0();
            return this;
        }

        @Override
        public boolean nextIndex() {
            IndexedChronicle.this.checkNotClosed();
            try {
                long index2 = this.index;
                if (this.indexForRead(this.index() + 1L)) {
                    return true;
                }
                this.index = index2;
                if (this.wasPadding()) {
                    ++this.index;
                    return this.indexForRead(this.index() + 1L);
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public long findMatch(@NotNull ExcerptComparator comparator) {
            long lo = 0L;
            long hi = IndexedChronicle.this.lastWrittenIndex();
            while (lo <= hi) {
                long mid = hi + lo >>> 1;
                if (!this.index(mid)) {
                    if (mid <= lo) break;
                    this.index(--mid);
                }
                int cmp = comparator.compare(this);
                this.finish();
                if (cmp < 0) {
                    lo = mid + 1L;
                    continue;
                }
                if (cmp > 0) {
                    hi = mid - 1L;
                    continue;
                }
                return mid;
            }
            return lo ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public void findRange(@NotNull long[] startEnd, @NotNull ExcerptComparator comparator) {
            int cmp;
            long mid;
            long lo1 = 0L;
            long hi1 = IndexedChronicle.this.lastWrittenIndex();
            long lo2 = 0L;
            long hi2 = hi1;
            boolean both = true;
            while (lo1 <= hi1) {
                mid = hi1 + lo1 >>> 1;
                if (!this.index(mid)) {
                    if (mid <= lo1) break;
                    this.index(--mid);
                }
                cmp = comparator.compare(this);
                this.finish();
                if (cmp < 0) {
                    lo1 = mid + 1L;
                    if (!both) continue;
                    lo2 = lo1;
                    continue;
                }
                if (cmp > 0) {
                    hi1 = mid - 1L;
                    if (!both) continue;
                    hi2 = hi1;
                    continue;
                }
                hi1 = mid - 1L;
                if (both) {
                    lo2 = mid + 1L;
                }
                both = false;
            }
            while (lo2 <= hi2) {
                mid = hi2 + lo2 >>> 1;
                if (!this.index(mid)) {
                    if (mid <= lo2) break;
                    this.index(--mid);
                }
                cmp = comparator.compare(this);
                this.finish();
                if (cmp <= 0) {
                    lo2 = mid + 1L;
                    continue;
                }
                hi2 = mid - 1L;
            }
            startEnd[0] = lo1;
            startEnd[1] = lo2;
        }
    }

    protected abstract class AbstractIndexedExcerpt
    extends NativeBytes
    implements ExcerptCommon {
        @NotNull
        final int cacheLineMask;
        final int dataBlockSize;
        final int indexBlockSize;
        final int indexEntriesPerLine;
        private final int indexEntriesPerBlock;
        private final int cacheLineSize;
        @Nullable
        VanillaMappedBytes indexBuffer;
        @Nullable
        VanillaMappedBytes dataBuffer;
        long index;
        long indexStartAddr;
        long indexBaseForLine;
        long dataStartAddr;
        long dataStartOffset;
        long indexPositionAddr;
        boolean padding;
        private long indexStartOffset;

        public String dumpState() {
            return "{cacheLineMask=" + this.cacheLineMask + "\ndataBlockSize=" + this.dataBlockSize + "\nindexBlockSize=" + this.indexBlockSize + "\nindexEntriesPerLine=" + this.indexEntriesPerLine + "\nindexEntriesPerBlock=" + this.indexEntriesPerBlock + "\ncacheLineSize=" + this.cacheLineSize + "\nindex=" + this.index + "\nindexStartAddr=" + this.indexStartAddr + "\nindexStartOffset=" + this.indexStartOffset + "\nindexBaseForLine=" + this.indexBaseForLine + "\ndataStartAddr=" + this.dataStartAddr + "\ndataStartOffset=" + this.dataStartOffset + "\nindexPositionAddr=" + this.indexPositionAddr + "\npadding=" + this.padding + '}';
        }

        protected AbstractIndexedExcerpt() throws IOException {
            super(BytesMarshallableSerializer.create(new VanillaBytesMarshallerFactory(), (ObjectSerializer)((Object)(IndexedChronicle.this.builder.useCompressedObjectSerializer() ? JDKZObjectSerializer.INSTANCE : JDKObjectSerializer.INSTANCE))), NO_PAGE, NO_PAGE, null);
            this.index = -1L;
            this.padding = true;
            this.cacheLineSize = IndexedChronicle.this.builder.cacheLineSize();
            this.cacheLineMask = this.cacheLineSize - 1;
            this.dataBlockSize = IndexedChronicle.this.builder.dataBlockSize();
            this.indexBlockSize = IndexedChronicle.this.builder.indexBlockSize();
            this.indexEntriesPerLine = (this.cacheLineSize - 8) / 4;
            this.indexEntriesPerBlock = this.indexBlockSize * this.indexEntriesPerLine / this.cacheLineSize;
            this.loadIndexBuffer();
            this.loadDataBuffer();
            this.finished = true;
        }

        @Override
        public long index() {
            return this.index;
        }

        protected ExcerptCommon toStart0() {
            this.index = -1L;
            return this;
        }

        protected ExcerptCommon toEndForRead0() {
            this.index = IndexedChronicle.this.size() - 1L;
            this.indexForRead(this.index);
            return this;
        }

        protected ExcerptCommon toEndForAppend0() {
            this.index = IndexedChronicle.this.size();
            try {
                this.indexForAppender(this.index);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        boolean indexForRead(long l) {
            try {
                if (l < 0L) {
                    this.setIndexBuffer(0L, true);
                    this.index = -1L;
                    this.padding = true;
                    return false;
                }
                long indexLookup = l / (long)this.indexEntriesPerBlock;
                long indexLookupMod = l % (long)this.indexEntriesPerBlock;
                this.setIndexBuffer(indexLookup, true);
                int indexLineEntry = (int)(indexLookupMod % (long)this.indexEntriesPerLine);
                int indexLineStart = (int)(indexLookupMod / (long)this.indexEntriesPerLine * (long)this.cacheLineSize);
                int inLine = (indexLineEntry << 2) + 8;
                int dataOffsetEnd = UNSAFE.getInt(this.indexStartAddr + (long)indexLineStart + (long)inLine);
                this.indexBaseForLine = UNSAFE.getLong(this.indexStartAddr + (long)indexLineStart);
                this.indexPositionAddr = this.indexStartAddr + (long)indexLineStart + (long)inLine;
                long dataOffsetStart = indexLineEntry == 0 ? this.indexBaseForLine : this.indexBaseForLine + (long)Math.abs(UNSAFE.getInt(this.indexPositionAddr - 4L));
                long dataLookup = dataOffsetStart / (long)this.dataBlockSize;
                long dataLookupMod = dataOffsetStart % (long)this.dataBlockSize;
                this.setDataBuffer(dataLookup);
                this.dataStartOffset = dataLookup * (long)this.dataBlockSize;
                this.startAddr = this.positionAddr = this.dataStartAddr + dataLookupMod;
                this.index = l;
                if (dataOffsetEnd > 0) {
                    this.limitAddr = this.dataStartAddr + (this.indexBaseForLine + (long)dataOffsetEnd - this.dataStartOffset);
                    this.indexPositionAddr += 4L;
                    this.padding = false;
                    return true;
                }
                if (dataOffsetEnd == 0) {
                    this.limitAddr = this.startAddr;
                    this.padding = false;
                    return false;
                }
                this.padding = true;
                return false;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        private void setIndexBuffer(long index, boolean prefetch) throws IOException {
            if (this.indexBuffer != null) {
                this.indexBuffer.release();
            }
            this.indexBuffer = IndexedChronicle.this.indexFileCache.acquire(index);
            this.indexPositionAddr = this.indexStartAddr = this.indexBuffer.address();
            this.indexStartOffset = index * (long)this.indexBlockSize;
        }

        void indexForAppender(long l) throws IOException {
            if (l < 0L) {
                throw new IndexOutOfBoundsException("index: " + l);
            }
            if (l == 0L) {
                this.indexStartOffset = 0L;
                this.loadIndexBuffer();
                this.dataStartOffset = 0L;
                this.loadDataBuffer();
                return;
            }
            long indexLookup = --l / (long)this.indexEntriesPerBlock;
            this.setIndexBuffer(indexLookup, true);
            long indexLookupMod = l % (long)this.indexEntriesPerBlock;
            int indexLineEntry = (int)(indexLookupMod % (long)this.indexEntriesPerLine);
            int indexLineStart = (int)(indexLookupMod / (long)this.indexEntriesPerLine * (long)this.cacheLineSize);
            int inLine = (indexLineEntry << 2) + 8;
            this.indexStartOffset = indexLookup * (long)this.indexBlockSize + (long)indexLineStart;
            this.indexBaseForLine = UNSAFE.getLong(this.indexStartAddr + (long)indexLineStart);
            long dataOffsetEnd = this.indexBaseForLine + (long)Math.abs(UNSAFE.getInt(this.indexStartAddr + (long)indexLineStart + (long)inLine));
            long dataLookup = dataOffsetEnd / (long)this.dataBlockSize;
            long dataLookupMod = dataOffsetEnd % (long)this.dataBlockSize;
            this.setDataBuffer(dataLookup);
            this.dataStartOffset = dataLookup * (long)this.dataBlockSize;
            this.startAddr = this.positionAddr = this.dataStartAddr + dataLookupMod;
            this.index = l + 1L;
            this.indexPositionAddr = this.indexStartAddr + (long)indexLineStart + (long)inLine + 4L;
        }

        private void setDataBuffer(long dataLookup) throws IOException {
            if (this.dataBuffer != null) {
                this.dataBuffer.release();
            }
            this.dataBuffer = IndexedChronicle.this.dataFileCache.acquire(dataLookup);
            this.dataStartAddr = this.dataBuffer.address();
        }

        @Override
        public boolean wasPadding() {
            return this.padding;
        }

        @Override
        public long size() {
            return IndexedChronicle.this.size();
        }

        @Override
        @NotNull
        public Chronicle chronicle() {
            return IndexedChronicle.this;
        }

        void loadNextIndexBuffer() throws IOException {
            this.indexStartOffset += (long)this.indexBlockSize;
            this.loadIndexBuffer();
        }

        void loadNextDataBuffer() throws IOException {
            this.dataStartOffset += (long)this.dataBlockSize;
            this.loadDataBuffer();
        }

        void loadNextDataBuffer(long offsetInThisBuffer) throws IOException {
            this.dataStartOffset += offsetInThisBuffer / (long)this.dataBlockSize * (long)this.dataBlockSize;
            this.loadDataBuffer();
        }

        void loadDataBuffer() throws IOException {
            this.setDataBuffer(this.dataStartOffset / (long)this.dataBlockSize);
            this.positionAddr = this.limitAddr = this.dataStartAddr;
            this.startAddr = this.limitAddr;
            this.capacityAddr = this.startAddr + this.dataBuffer.capacity();
        }

        void loadIndexBuffer() throws IOException {
            this.setIndexBuffer(this.indexStartOffset / (long)this.indexBlockSize, true);
        }

        boolean index(long index) {
            throw new UnsupportedOperationException();
        }
    }
}

