/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.Disposable;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.OpenHashSet;

final class SingleScheduler
implements Scheduler {
    static final AtomicLong COUNTER = new AtomicLong();
    final ThreadFactory factory;
    volatile ExecutorService executor;
    static final AtomicReferenceFieldUpdater<SingleScheduler, ExecutorService> EXECUTORS = AtomicReferenceFieldUpdater.newUpdater(SingleScheduler.class, ExecutorService.class, "executor");
    static final ExecutorService TERMINATED = Executors.newSingleThreadExecutor();

    public SingleScheduler(ThreadFactory factory) {
        this.factory = factory;
        this.init();
    }

    private void init() {
        EXECUTORS.lazySet(this, Executors.newSingleThreadExecutor(this.factory));
    }

    @Override
    public boolean isDisposed() {
        return this.executor == TERMINATED;
    }

    @Override
    public void start() {
        ExecutorService a;
        ExecutorService b = null;
        do {
            if ((a = this.executor) != TERMINATED) {
                if (b != null) {
                    b.shutdownNow();
                }
                return;
            }
            if (b != null) continue;
            b = Executors.newSingleThreadExecutor(this.factory);
        } while (!EXECUTORS.compareAndSet(this, a, b));
    }

    @Override
    public void shutdown() {
        this.dispose();
    }

    @Override
    public void dispose() {
        ExecutorService a = this.executor;
        if (a != TERMINATED && (a = EXECUTORS.getAndSet(this, TERMINATED)) != TERMINATED) {
            Schedulers.safeExecutorServiceShutdown(a, "Single");
        }
    }

    @Override
    public Disposable schedule(Runnable task) {
        try {
            Future<?> f = this.executor.submit(task);
            return () -> f.cancel(this.executor == TERMINATED);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new SingleWorker(this.executor);
    }

    static {
        TERMINATED.shutdownNow();
    }

    static final class SingleWorker
    implements Scheduler.Worker {
        final ExecutorService exec;
        OpenHashSet<SingleWorkerTask> tasks;
        volatile boolean shutdown;

        public SingleWorker(ExecutorService exec) {
            this.exec = exec;
            this.tasks = new OpenHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Disposable schedule(Runnable task) {
            Future<?> f;
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            SingleWorkerTask pw = new SingleWorkerTask(task, this);
            SingleWorker singleWorker = this;
            synchronized (singleWorker) {
                if (this.shutdown) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(pw);
            }
            try {
                f = this.exec.submit(pw);
            }
            catch (RejectedExecutionException ex) {
                return Scheduler.REJECTED;
            }
            if (this.shutdown) {
                f.cancel(true);
                return pw;
            }
            pw.setFuture(f);
            return pw;
        }

        @Override
        public void shutdown() {
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            OpenHashSet<SingleWorkerTask> set;
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            SingleWorker singleWorker = this;
            synchronized (singleWorker) {
                set = this.tasks;
                this.tasks = null;
            }
            if (set != null && !set.isEmpty()) {
                Object[] a;
                for (Object o : a = set.keys()) {
                    if (o == null) continue;
                    ((SingleWorkerTask)o).cancelFuture();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.shutdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(SingleWorkerTask task) {
            if (this.shutdown) {
                return;
            }
            SingleWorker singleWorker = this;
            synchronized (singleWorker) {
                if (this.shutdown) {
                    return;
                }
                this.tasks.remove(task);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int pendingTasks() {
            if (this.shutdown) {
                return 0;
            }
            SingleWorker singleWorker = this;
            synchronized (singleWorker) {
                OpenHashSet<SingleWorkerTask> set = this.tasks;
                if (set != null) {
                    return set.size();
                }
                return 0;
            }
        }

        static final class SingleWorkerTask
        implements Runnable,
        Disposable {
            final Runnable run;
            final SingleWorker parent;
            volatile boolean cancelled;
            volatile Future<?> future;
            static final AtomicReferenceFieldUpdater<SingleWorkerTask, Future> FUTURE = AtomicReferenceFieldUpdater.newUpdater(SingleWorkerTask.class, Future.class, "future");
            static final Future<Object> FINISHED = CompletableFuture.completedFuture(null);
            static final Future<Object> CANCELLED = CompletableFuture.completedFuture(null);

            public SingleWorkerTask(Runnable run, SingleWorker parent) {
                this.run = run;
                this.parent = parent;
            }

            @Override
            public void run() {
                if (this.cancelled || this.parent.shutdown) {
                    return;
                }
                try {
                    try {
                        this.run.run();
                    }
                    catch (Throwable ex) {
                        Schedulers.handleError(ex);
                    }
                }
                finally {
                    Future<?> f;
                    while ((f = this.future) != CANCELLED) {
                        if (!FUTURE.compareAndSet(this, f, FINISHED)) continue;
                        this.parent.remove(this);
                        break;
                    }
                }
            }

            @Override
            public boolean isDisposed() {
                Future<?> a = this.future;
                return FINISHED == a || CANCELLED == a;
            }

            @Override
            public void dispose() {
                if (!this.cancelled) {
                    this.cancelled = true;
                    Future<Object> f = this.future;
                    if (f != CANCELLED && f != FINISHED && (f = FUTURE.getAndSet(this, CANCELLED)) != CANCELLED && f != FINISHED) {
                        if (f != null) {
                            f.cancel(this.parent.shutdown);
                        }
                        this.parent.remove(this);
                    }
                }
            }

            void setFuture(Future<?> f) {
                if (!(this.future == null && FUTURE.compareAndSet(this, null, f) || this.future == FINISHED)) {
                    f.cancel(this.parent.shutdown);
                }
            }

            void cancelFuture() {
                Future<Object> f = this.future;
                if (f != CANCELLED && f != FINISHED && (f = FUTURE.getAndSet(this, CANCELLED)) != null && f != CANCELLED && f != FINISHED) {
                    f.cancel(true);
                }
            }
        }
    }
}

