/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.Disposable;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.OpenHashSet;

final class ElasticScheduler
implements Scheduler {
    static final AtomicLong COUNTER = new AtomicLong();
    static final ThreadFactory EVICTOR_FACTORY = r -> {
        Thread t = new Thread(r, "elastic-evictor-" + COUNTER.incrementAndGet());
        t.setDaemon(true);
        return t;
    };
    final ThreadFactory factory;
    final int ttlSeconds;
    static final int DEFAULT_TTL_SECONDS = 60;
    final Queue<ExecutorServiceExpiry> cache;
    final Queue<ExecutorService> all;
    final ScheduledExecutorService evictor;
    static final ExecutorService SHUTDOWN = Executors.newSingleThreadExecutor();
    volatile boolean shutdown;

    public ElasticScheduler(ThreadFactory factory, int ttlSeconds) {
        this.ttlSeconds = ttlSeconds;
        this.factory = factory;
        this.cache = new ConcurrentLinkedQueue<ExecutorServiceExpiry>();
        this.all = new ConcurrentLinkedQueue<ExecutorService>();
        this.evictor = Executors.newScheduledThreadPool(1, EVICTOR_FACTORY);
        this.evictor.scheduleAtFixedRate(this::eviction, ttlSeconds, ttlSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException("Restarting not supported yet");
    }

    @Override
    public boolean isDisposed() {
        return this.shutdown;
    }

    @Override
    public void shutdown() {
        this.dispose();
    }

    @Override
    public void dispose() {
        ExecutorService exec;
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.evictor.shutdownNow();
        this.cache.clear();
        while ((exec = this.all.poll()) != null) {
            exec.shutdownNow();
        }
    }

    ExecutorService pick() {
        if (this.shutdown) {
            return SHUTDOWN;
        }
        ExecutorServiceExpiry e = this.cache.poll();
        if (e != null) {
            return e.executor;
        }
        ExecutorService result = Executors.newSingleThreadExecutor(this.factory);
        this.all.offer(result);
        if (this.shutdown) {
            this.all.remove(result);
            return SHUTDOWN;
        }
        return result;
    }

    @Override
    public Disposable schedule(Runnable task) {
        Future<?> f;
        ExecutorService exec = this.pick();
        Runnable wrapper = () -> {
            try {
                try {
                    task.run();
                }
                catch (Throwable ex) {
                    Schedulers.handleError(ex);
                }
            }
            finally {
                this.release(exec);
            }
        };
        try {
            f = exec.submit(wrapper);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
        return () -> f.cancel(true);
    }

    @Override
    public Scheduler.Worker createWorker() {
        ExecutorService exec = this.pick();
        return new CachedWorker(exec, this);
    }

    void release(ExecutorService exec) {
        if (exec != SHUTDOWN && !this.shutdown) {
            ExecutorServiceExpiry e = new ExecutorServiceExpiry(exec, System.currentTimeMillis() + (long)this.ttlSeconds * 1000L);
            this.cache.offer(e);
            if (this.shutdown && this.cache.remove(e)) {
                exec.shutdownNow();
            }
        }
    }

    void eviction() {
        long now = System.currentTimeMillis();
        ArrayList<ExecutorServiceExpiry> list = new ArrayList<ExecutorServiceExpiry>(this.cache);
        for (ExecutorServiceExpiry e : list) {
            if (e.expireMillis >= now || !this.cache.remove(e)) continue;
            e.executor.shutdownNow();
        }
    }

    static {
        SHUTDOWN.shutdownNow();
    }

    static final class CachedWorker
    implements Scheduler.Worker {
        final ExecutorService executor;
        final ElasticScheduler parent;
        volatile boolean shutdown;
        OpenHashSet<CachedTask> tasks;

        public CachedWorker(ExecutorService executor, ElasticScheduler parent) {
            this.executor = executor;
            this.parent = parent;
            this.tasks = new OpenHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Disposable schedule(Runnable task) {
            Future<?> f;
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            CachedTask ct = new CachedTask(task, this);
            CachedWorker cachedWorker = this;
            synchronized (cachedWorker) {
                if (this.shutdown) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(ct);
            }
            try {
                f = this.executor.submit(ct);
            }
            catch (RejectedExecutionException ex) {
                return Scheduler.REJECTED;
            }
            ct.setFuture(f);
            return ct;
        }

        @Override
        public void shutdown() {
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            OpenHashSet<CachedTask> set;
            if (this.shutdown) {
                return;
            }
            CachedWorker cachedWorker = this;
            synchronized (cachedWorker) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                set = this.tasks;
                this.tasks = null;
            }
            if (!set.isEmpty()) {
                Object[] keys;
                for (Object o : keys = set.keys()) {
                    if (o == null) continue;
                    ((CachedTask)o).cancelFuture();
                }
            }
            this.parent.release(this.executor);
        }

        @Override
        public boolean isDisposed() {
            return this.shutdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(CachedTask task) {
            if (this.shutdown) {
                return;
            }
            CachedWorker cachedWorker = this;
            synchronized (cachedWorker) {
                if (this.shutdown) {
                    return;
                }
                this.tasks.remove(task);
            }
        }

        static final class CachedTask
        extends AtomicReference<Future<?>>
        implements Runnable,
        Disposable {
            private static final long serialVersionUID = 6799295393954430738L;
            final Runnable run;
            final CachedWorker parent;
            volatile boolean cancelled;
            static final FutureTask<Object> CANCELLED = new FutureTask<Object>(() -> {}, null);
            static final FutureTask<Object> FINISHED = new FutureTask<Object>(() -> {}, null);

            public CachedTask(Runnable run, CachedWorker parent) {
                this.run = run;
                this.parent = parent;
            }

            @Override
            public void run() {
                try {
                    if (!this.parent.shutdown && !this.cancelled) {
                        this.run.run();
                    }
                }
                catch (Throwable ex) {
                    Schedulers.handleError(ex);
                }
                finally {
                    this.lazySet(FINISHED);
                    this.parent.remove(this);
                }
            }

            @Override
            public void dispose() {
                this.cancelled = true;
                this.cancelFuture();
            }

            @Override
            public boolean isDisposed() {
                Future f = (Future)this.get();
                return f == CANCELLED || f == FINISHED;
            }

            void setFuture(Future<?> f) {
                if (!this.compareAndSet(null, f) && this.get() != FINISHED) {
                    f.cancel(true);
                }
            }

            void cancelFuture() {
                Future f = (Future)this.get();
                if (f != CANCELLED && f != FINISHED && (f = (Future)this.getAndSet(CANCELLED)) != null && f != CANCELLED && f != FINISHED) {
                    f.cancel(true);
                }
            }
        }
    }

    static final class ExecutorServiceExpiry {
        final ExecutorService executor;
        final long expireMillis;

        public ExecutorServiceExpiry(ExecutorService executor, long expireMillis) {
            this.executor = executor;
            this.expireMillis = expireMillis;
        }
    }
}

