/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class SpscFreeListTracker<T> {
    private volatile T[] array = this.empty();
    private int[] free = FREE_EMPTY;
    private long producerIndex;
    private long consumerIndex;
    volatile int size;
    static final AtomicIntegerFieldUpdater<SpscFreeListTracker> SIZE = AtomicIntegerFieldUpdater.newUpdater(SpscFreeListTracker.class, "size");
    private static final int[] FREE_EMPTY = new int[0];

    SpscFreeListTracker() {
    }

    protected abstract T[] empty();

    protected abstract T[] terminated();

    protected abstract T[] newArray(int var1);

    protected abstract void unsubscribeEntry(T var1);

    protected abstract void setIndex(T var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void unsubscribe() {
        T[] t = this.terminated();
        T[] TArray = this;
        synchronized (this) {
            T[] a = this.array;
            if (a == t) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            SIZE.lazySet((SpscFreeListTracker)this, 0);
            this.free = null;
            this.array = t;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (T e : a) {
                if (e == null) continue;
                this.unsubscribeEntry(e);
            }
            return;
        }
    }

    public final T[] get() {
        return this.array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean add(T entry) {
        T[] a = this.array;
        if (a == this.terminated()) {
            return false;
        }
        SpscFreeListTracker spscFreeListTracker = this;
        synchronized (spscFreeListTracker) {
            a = this.array;
            if (a == this.terminated()) {
                return false;
            }
            int idx = this.pollFree();
            if (idx < 0) {
                int n = a.length;
                T[] b = n != 0 ? this.newArray(n << 1) : this.newArray(4);
                System.arraycopy(a, 0, b, 0, n);
                this.array = b;
                a = b;
                int m = b.length;
                int[] u = new int[m];
                for (int i = n + 1; i < m; ++i) {
                    u[i] = i;
                }
                this.free = u;
                this.consumerIndex = n + 1;
                this.producerIndex = m;
                idx = n;
            }
            this.setIndex(entry, idx);
            SIZE.lazySet(this, this.size);
            a[idx] = entry;
            SIZE.lazySet(this, this.size + 1);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(int index) {
        SpscFreeListTracker spscFreeListTracker = this;
        synchronized (spscFreeListTracker) {
            T[] a = this.array;
            if (a != this.terminated()) {
                a[index] = null;
                this.offerFree(index);
                SIZE.lazySet(this, this.size - 1);
            }
        }
    }

    private int pollFree() {
        int[] a = this.free;
        int m = a.length - 1;
        long ci = this.consumerIndex;
        if (this.producerIndex == ci) {
            return -1;
        }
        int offset = (int)ci & m;
        this.consumerIndex = ci + 1L;
        return a[offset];
    }

    private void offerFree(int index) {
        int[] a = this.free;
        int m = a.length - 1;
        long pi = this.producerIndex;
        int offset = (int)pi & m;
        a[offset] = index;
        this.producerIndex = pi + 1L;
    }

    protected final boolean isEmpty() {
        return this.size == 0;
    }
}

