/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.logging.Level;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxOnAssembly;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ParallelFlux;
import reactor.core.publisher.SignalPeek;
import reactor.core.publisher.SignalType;
import reactor.util.Logger;
import reactor.util.Loggers;

final class SignalLogger<IN>
implements SignalPeek<IN> {
    static final int SUBSCRIBE = 128;
    static final int ON_SUBSCRIBE = 64;
    static final int ON_NEXT = 32;
    static final int ON_ERROR = 16;
    static final int ON_COMPLETE = 8;
    static final int REQUEST = 4;
    static final int CANCEL = 2;
    static final int AFTER_TERMINATE = 1;
    static final int ALL = 254;
    static final AtomicLong IDS = new AtomicLong(1L);
    final Publisher<IN> source;
    final Logger log;
    final boolean fuseable;
    final int options;
    final Level level;
    final String operatorLine;
    final long id;
    static final String LOG_TEMPLATE = "{}({})";
    static final String LOG_TEMPLATE_FUSEABLE = "| {}({})";

    public SignalLogger(Publisher<IN> source, String category, Level level, boolean correlateStack, SignalType ... options) {
        this(source, category, level, correlateStack, Loggers::getLogger, options);
    }

    public SignalLogger(Publisher<IN> source, String category, Level level, boolean correlateStack, Function<String, Logger> loggerSupplier, SignalType ... options) {
        this.source = Objects.requireNonNull(source, "source");
        this.id = IDS.getAndIncrement();
        this.fuseable = source instanceof Fuseable;
        this.operatorLine = correlateStack ? FluxOnAssembly.extract(FluxOnAssembly.takeStacktrace(null), false) : null;
        boolean generated = category == null || category.isEmpty() || category.endsWith(".");
        String string = category = generated && category == null ? "reactor." : category;
        if (generated) {
            category = source instanceof Mono ? category + "Mono." + source.getClass().getSimpleName().replace("Mono", "") : (source instanceof ParallelFlux ? category + "Parallel." + source.getClass().getSimpleName().replace("Parallel", "").replace("Unordered", "") : category + "Flux." + source.getClass().getSimpleName().replace("Flux", ""));
            category = category + "." + this.id;
        }
        this.log = loggerSupplier.apply(category);
        this.level = level;
        if (options == null || options.length == 0) {
            this.options = 254;
        } else {
            int opts = 0;
            for (SignalType option : options) {
                if (option == SignalType.CANCEL) {
                    opts |= 2;
                    continue;
                }
                if (option == SignalType.ON_SUBSCRIBE) {
                    opts |= 0x40;
                    continue;
                }
                if (option == SignalType.REQUEST) {
                    opts |= 4;
                    continue;
                }
                if (option == SignalType.ON_NEXT) {
                    opts |= 0x20;
                    continue;
                }
                if (option == SignalType.ON_ERROR) {
                    opts |= 0x10;
                    continue;
                }
                if (option == SignalType.ON_COMPLETE) {
                    opts |= 8;
                    continue;
                }
                if (option == SignalType.SUBSCRIBE) {
                    opts |= 0x80;
                    continue;
                }
                if (option != SignalType.AFTER_TERMINATE) continue;
                opts |= 1;
            }
            this.options = opts;
        }
    }

    void log(Object ... args) {
        String line;
        String string = line = this.fuseable ? LOG_TEMPLATE_FUSEABLE : LOG_TEMPLATE;
        if (this.operatorLine != null) {
            line = line + " " + this.operatorLine;
        }
        if (this.level == Level.FINEST) {
            this.log.trace(line, args);
        } else if (this.level == Level.FINE) {
            this.log.debug(line, args);
        } else if (this.level == Level.INFO) {
            this.log.info(line, args);
        } else if (this.level == Level.WARNING) {
            this.log.warn(line, args);
        } else if (this.level == Level.SEVERE) {
            this.log.error(line, args);
        }
    }

    @Override
    public Consumer<? super Subscription> onSubscribeCall() {
        if ((this.options & 0x40) == 64 && (this.level != Level.INFO || this.log.isInfoEnabled())) {
            return s -> this.log(new Object[]{SignalType.ON_SUBSCRIBE, this.subscriptionAsString((Subscription)s), this.source});
        }
        return null;
    }

    String subscriptionAsString(Subscription s) {
        if (s == null) {
            return "null subscription";
        }
        StringBuilder asString = new StringBuilder();
        if (s instanceof Fuseable.SynchronousSubscription) {
            asString.append("[Synchronous Fuseable] ");
        } else if (s instanceof Fuseable.QueueSubscription) {
            asString.append("[Fuseable] ");
        }
        Class<?> clazz = s.getClass();
        String name = clazz.getCanonicalName();
        if (name == null) {
            name = clazz.getName();
        }
        name = name.replaceFirst(clazz.getPackage().getName() + ".", "");
        asString.append(name);
        return asString.toString();
    }

    @Override
    public Consumer<? super IN> onNextCall() {
        if ((this.options & 0x20) == 32 && (this.level != Level.INFO || this.log.isInfoEnabled())) {
            return d -> this.log(new Object[]{SignalType.ON_NEXT, d, this.source});
        }
        return null;
    }

    @Override
    public Consumer<? super Throwable> onErrorCall() {
        if ((this.options & 0x10) == 16 && this.log.isErrorEnabled()) {
            String line;
            String string = line = this.fuseable ? LOG_TEMPLATE_FUSEABLE : LOG_TEMPLATE;
            if (this.operatorLine != null) {
                line = line + " " + this.operatorLine;
            }
            String s = line;
            return e -> {
                this.log.error(s, new Object[]{SignalType.ON_ERROR, e, this.source});
                this.log.error("", (Throwable)e);
            };
        }
        return null;
    }

    @Override
    public Runnable onCompleteCall() {
        if ((this.options & 8) == 8 && (this.level != Level.INFO || this.log.isInfoEnabled())) {
            return () -> this.log(new Object[]{SignalType.ON_COMPLETE, "", this.source});
        }
        return null;
    }

    @Override
    public Runnable onAfterTerminateCall() {
        if ((this.options & 1) == 1 && (this.level != Level.INFO || this.log.isInfoEnabled())) {
            return () -> this.log(new Object[]{SignalType.AFTER_TERMINATE, "", this.source});
        }
        return null;
    }

    @Override
    public LongConsumer onRequestCall() {
        if ((this.options & 4) == 4 && (this.level != Level.INFO || this.log.isInfoEnabled())) {
            return n -> this.log(new Object[]{SignalType.REQUEST, Long.MAX_VALUE == n ? "unbounded" : Long.valueOf(n), this.source});
        }
        return null;
    }

    @Override
    public Runnable onCancelCall() {
        if ((this.options & 2) == 2 && (this.level != Level.INFO || this.log.isInfoEnabled())) {
            return () -> this.log(new Object[]{SignalType.CANCEL, "", this.source});
        }
        return null;
    }

    public String toString() {
        return "/loggers/" + this.log.getName() + "/" + this.id;
    }

    @Override
    public Publisher<? extends IN> upstream() {
        return this.source;
    }
}

